/*
  fringeMath.hpp

  All the routines necessary for calculating the fringe positions from
  the raw data.

  David Mozurkewich -- 21 February 2002
  ================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "memory.h"


class fringeMath
{
public :
  fringeMath ( int iBins, int iFreq, int iWaves, float *pfWaves ) ;
  float calcXYN( int **piData ) ;
  float calcGD ( int iF, float *pfSNR ) ;

  int getSpectrum( int iF, float **pfX, float **pfY ) ;
  void displayData ( float fTime, float fDelay ) ;

private :
  int iNumWaves ;
  int iNumBins ;
  int iMaxFreq ;
  int iNumDelays ;

  float fDeltaD, fDelay0 ;

  float *pfWave ;
  float **pfX, **pfY, *pfN ;
  float **pfGD, *pfMaxAmp, *pfGroupDelay ;
  float fSNR ;
} ;
