/*
  fringeSpectrum.cpp

  Calculates an over-sampled fringe spectrum for analysis of stroke 
  problems.

  David Mozurkewich -- 23 May 2002
  ================================================================*/
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "dmmath.h"
#include "memory.h"
#include "display.hpp" 
#include "fringeSpectrum.hpp"

fringeSpectrum::fringeSpectrum ( void )
{
  int i ;
  iNumBins = 64 ;
  fDeltaFreq = 0.15 ;
  fMaxFreq =   12.0 ;
  iNumWaves = 32 ;

  fMinFreq   = fDeltaFreq ;
  iNumFreq = int(1.5 + (fMaxFreq - fMinFreq)/fDeltaFreq) ;
  pDisplay = new display ( XY ) ;
  pDisplay->setTitles( "Fringe Frequency (Cycles/modulation)",
		       "Fringe Power", "Fringe Spectrum " ) ;

  pfF   = alloc1df( iNumFreq ) ;
  pfPwr = alloc1df( iNumFreq ) ;

  for ( i = 0 ; i < iNumFreq  ; i++ )
    pfF[i] = fMinFreq + i * fDeltaFreq ;
} ;

/** =================================================
    fringeSpectrum::calc   calculate fringe spectrum

    =================================================*/
void fringeSpectrum::calc ( int **piData )
{
  int iB, iF, iW, *piD ;
  float fArg, fX, fY, fI0 ;

  /* Choose channel 0 = reddest wavelength */

  iW = 0 ;

  /* calculate the mean counts per bin.  this is needed for the
     denominator and should be subtracted off the numberator to get
     the right answer.  */

  fI0 = 0. ;
  piD = piData[iW] ;
  for ( iB = 0; iB < iNumBins ; iB++ )
    fI0 += *piD++ ;
  fI0 /= iNumBins ;

  /* Calculate the power at each fringe frequency */

  for ( iF = 0 ; iF < iNumFreq ; iF++ )
    {
      fX  = 0. ;
      fY  = 0. ;
      piD = piData[iW] ;
      fArg = 2.*PI*pfF[iF]/(float)iNumBins ;
      for ( iB = 0; iB < iNumBins ; iB++ )
	{
	  fX  += (*piD-fI0) * cos(iB * fArg) ;
	  fY  += (*piD-fI0) * sin(iB * fArg) ;
	  piD++ ;
	}
      pfPwr[iF] = 4.*(fX*fX + fY*fY)/( iNumBins*iNumBins*fI0*fI0 ) ;
    }
}


void fringeSpectrum::showFS ( void )
{
  pDisplay->plotXY( iNumFreq, pfF, pfPwr ) ;
}

