/*

  Simulation of the Fast Steering Mirror  performance

  angles are all in microRadians
  Error signals are in terms of the quad cell error function.

  ====================================================*/


class fsm
{
public :

  fsm ( float fTheta ) ;
  float getTip( float fTime ) ;
  float getTilt( float fTime ) ;
  void move( float fTime, float fDeltaTip, float fDeltaTilt ); 
  void servoTipTilt ( float fTime, float fErrorX, float fErrorY ) ;

private :

  int iNumRecs ;
  int iBufferSize ;

  float *pfTime ;
  float *pfTip ;
  float *pfTilt ;
  float fTime0, fDeltaTime ;

  float fUpRail ;
  float fDownRail ;
  float fCenter ;
  float fRange ;

  float fTimeDelay ;

} ;
