/*

  sineWave.cpp

  This is a substitute for the atmosphere functions
  and is intended for debugging the servos
  ========================================================*/

#include <math.h>
#include "memory.h"
#include "../atmos/npoi.h"
#include "sineWave.hpp"

/** =============================
    atmosphere constructor

    =============================*/

sineWave::sineWave ( float fA, float fF )
{
  fAmp  = fA ;
  fFreq = fF ;
  fArg  = 2.*PI*fFreq ;
}

/** ==========================================
    sineWave::getDelay

    returns the delay on this baseline
    for the specified time
    ==========================================*/
float sineWave::getDelay( float fTime )
{
  float fDelay ;

  fDelay = fAmp * sin ( fArg * fTime ) ;

  return(fDelay) ; 
}

