/* ******************************************************************** */
/** bincount.C								*/
/** 2002-07-16 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <npoi_container.h>

/* ******************************************************************** */
int main(int argc, char **argv) {
	NPOI_CONTAINER	*d;
	int		iSpec;
	int		iChan;
	int		iFrame;
	int		iBin;
	int		nChan;
	int		nBin;
	int		*binTotal;
	char		*inFile = NULL;
	char		c;
	char		bHelp = 0;

	while((c = getopt(argc, argv, "s:i:h")) != EOF) {
		switch(c) {
			case 's' :
				iSpec = atoi(optarg);
				break;
			case 'i' :
				inFile = optarg;
				break;
			case 'h' :
			default  :
				bHelp = 1;
				break;
		}
	}

	if(bHelp || argc < 2) {
		fprintf(stderr, "Usage: %s -i FILE -r RECORD -s SPEC\n",
				argv[0]);
		exit(1);
	}

	d = new NPOI_CONTAINER(inFile);

	nBin = d->config->nBin;
	nChan = d->config->nChan;

	binTotal = (int *)calloc(nChan, sizeof(int));

	for(iFrame = 0; (unsigned int)iFrame < d->config->nFrame;
			iFrame++)
	{
		for(iChan = 0; iChan < nChan; iChan++) {
			for(iBin = 0; iBin < nBin; iBin++) {
				binTotal[iChan] +=
					d->frames[iFrame].
					photonCounts[iSpec][iChan][iBin];
			}
		}
	}

	delete d;

	for(iChan = 0; iChan < nChan; iChan++) {
		printf("%d\n", binTotal[iChan]);
	}
}
