/* ******************************************************************** */
/** binsum.C								*/
/** 2002-07-03 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <npoi_container.h>
#include "wavelength.h"

extern "C" {
#include <cpgplot.h>
}

#define NUM_WIN 20
#define NUM_SHOW 1
#define NUM_INC 1
#define TEMP_SF 2.5

/* ******************************************************************** */
int main(int argc, char **argv) {
	NPOI_CONTAINER	*d;
	int		iSpec;
	int		iChan;
	int		iFrame;
	int		i;
	int		iBin;
	int		nChan;
	int		nBin;
	float		*out0;
	float		*out1;
	float		tr[] = {-1, 1, 0, -1, 0, 1};
	float		min = 10000000;
	float		max = -10000000;
	char		buf[BUFSIZ];
	wavelength	*wave;
	int		*fMap;
	int		*rMap;

	if(argc < 4) {
		fprintf(stderr, "Usage: %s INFILE WAVEFILE SPEC\n",
				argv[0]);
		exit(1);
	}

	d = new NPOI_CONTAINER(argv[1]);

	if(d->config == NULL) {
		fprintf(stderr, "No data loaded\n");
		exit(1);
	}

	wave = new wavelength();
	wave->load(argv[2]);

	iSpec = atoi(argv[3]);

	nBin = d->config->nBin;
	nChan = d->config->nChan;

	out0 = (float *)calloc(nChan * nBin, sizeof(float));
	out1 = (float *)calloc(nChan * nBin, sizeof(float));

	cpgopen("/xwin");

	cpgenv(-0.5, nChan - 0.5, -0.5, nBin - 0.5, 0, 0);
	cpgask(0);

	sprintf(buf, "File %s, spec %d, range=[%.2f,%.2f]",
			argv[1], iSpec, min, max);
	cpglab("bogoChan", "Bin", buf);

	cpgsch(0.8);

	fMap = wave->fMap[iSpec];
	rMap = wave->rMap[iSpec];

	for(iChan = 0; iChan < nChan; iChan++) {
		sprintf(buf, "%.2f", wave->center[iSpec][rMap[iChan]]);
		if(iChan % 2) {
			cpgptxt(iChan - 0.5, nBin + 0.5, 0, 0, buf);
		} else {
			cpgptxt(iChan - 0.5, nBin + 1.5, 0, 0, buf);
		}
	}

	cpgsch(1.0);

	for(iFrame = 0; (unsigned int)iFrame < d->config->nFrame -
			NUM_WIN; iFrame += NUM_INC)
	{
		min = 0;
		max = 0;

		for(iChan = 0; iChan < nChan; iChan++) {
			for(iBin = 0; iBin < nBin; iBin++) {
				if(!(iFrame % NUM_SHOW)) {
					out1[iBin * nChan + fMap[iChan]] +=
					  out0[iBin * nChan + fMap[iChan]];
					out0[iBin * nChan + fMap[iChan]] = 0;
				}

				for(i = 0; i < NUM_WIN; i++) {
					out0[iBin * nChan + fMap[iChan]] +=
						d->frames[iFrame + i].
						photonCounts[iSpec][iChan]
						[iBin];
				}
			}
		}

		if(!(iFrame % NUM_SHOW)) {
			cpggray(out0, nChan, nBin, 1, nChan, 1, nBin,
					TEMP_SF * NUM_WIN, 0, tr);
		}
	}

	cpgask(1);

	cpggray(out1, nChan, nBin, 1, nChan, 1, nBin, 500 * TEMP_SF * NUM_WIN,
			0, tr);

	cpgclos();

	delete d;
}
