/* ******************************************************************** */
/* calculateBounds.C							*/
/* 2002-07-29 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>

#include "wavelength.h"

int main(int argc, char **argv) {
	wavelength	*wave;
	int		iSpec;
	int		iChan;
	float		u, v, z;

	if(argc < 3) {
		fprintf(stderr, "Usage: %s INWAVEFILE OUTWAVEFILE\n",
				argv[0]);
		exit(1);
	}

	wave = new wavelength();

	wave->load(argv[1]);

	for(iSpec = 0; iSpec < wave->nSpec; iSpec++) {
		for(iChan = 0; iChan < wave->nChan - 1; iChan++) {
			/* ******************************************** */
			/* Assume the channels are sorted in decreasing	*/
			/* order.  REDDEST END FIRST!			*/
			/* ******************************************** */
			u = 1 / wave->center[iSpec][iChan];
			v = 1 / wave->center[iSpec][iChan + 1];

			z = (u + v) / 2;
			z = 1 / z;

			wave->blue[iSpec][iChan] = z;
			wave->red[iSpec][iChan + 1] = z;
		}

		wave->red[iSpec][0] = 2 * (wave->center[iSpec][0]) -
			wave->blue[iSpec][0];

		wave->blue[iSpec][wave->nChan - 1] =
			2 * (wave->center[iSpec][wave->nChan - 1]) -
			wave->red[iSpec][wave->nChan - 1];
	}

	wave->save(argv[2], 3);

	delete wave;

	exit(0);
}
