/** =======================================================================
    configure.C    configuration class.

    gets user input
    opens data file
    makes configuration data available to the rest of the programs.


    2002-08-20 written by David Mozurkewich

    ========================================================================*/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <npoi_container.h>
#include "wavelength.h"
#include "configure.h"

/** ======================================================================
    configure::configure( int iArgs, char *pcArgs[] )
    Constructor
    ======================================================================*/
configure::configure(int iArgs, char *pcArg[] )
{
  int i ;
  if(iArgs < 5)
    {
      fprintf(stderr, "Usage: %s INFILE WAVEFILE SPEC CHAN [CHAN ...]\n",
	      pcArg[0]);
      exit(1);
    }

  pcFileName = pcArg[1] ;
  pcWaveFile = pcArg[2] ;
  iSpect = atoi(pcArg[3]);
  iNumChans = iArgs - 4 ;
  piChanList = new int[iNumChans] ;
  for ( i = 0 ; i < iNumChans ; i++ )
    piChanList[i] = atoi( pcArg[i+4] ) ;

  pFout = fopen ( "outputFile.dat", "w" ) ;

  /* ========================================================
     Part 2.  open the data file 
     and read all data into memory, into the NPOI_container
     ========================================================*/

  
  pD = new NPOI_CONTAINER(pcFileName);
  if(pD->config == NULL)
    {
      fprintf(stderr, "No data loaded\n");
      exit(1);
    }
  printf ( "npoiContainer configured\n" ) ;

  pWave = new wavelength(pD->config);
  pWave->load(pcWaveFile);
  printf ( "wavelength configuration complete\n" ) ;
}

FILE *configure::getOutputStream(void)
{
  return (pFout) ;
}


float configure::getWaveln( int iSp, int iCh )
{
  return ( pWave->center[iSp][iCh] ) ;
}




NPOI_FRAME *configure::getData(void)
{
  return ( pD->frames ) ;
}

int configure::getSpect(void)
{
  return ( iSpect) ;
}

int configure::getNumChans(void)
{
  return ( iNumChans) ;
}

int *configure::getChanList(void)
{
  return ( piChanList) ;
}

char *configure::getFileName(void)
{
  return ( pcFileName ) ;
}

int configure::getNumFrames(void)
{
  return ( pD->config->nFrame ) ;
}

int configure::getNumBins(void)
{
  return ( pD->config->nBin ) ;
}




