/* ******************************************************************** */
/** fringeParam.C							*/
/** 2002-07-10 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <math.h>
#include "fringeParam.h"

/* ******************************************************************** */
/** fringeParam::fringeParam()
    Constructor, zeros the whole structure.				*/
/* ******************************************************************** */
fringeParam::fringeParam() {
	iSpec = 0;
	iChan = 0;
	k = 0;

	nBin = 0;

	I0 = 0;
	X = 0;
	Y = 0;
	time = 0;
}

/* ******************************************************************** */
/** fringeParam::fringeParam(NPOI_CONFIG *conf)
    Constructor, zeros the whole structure but sets appropriate values
    from conf if they exist.						*/
/* ******************************************************************** */
fringeParam::fringeParam(NPOI_CONFIG *conf) {
	iSpec = 0;
	iChan = 0;
	k = 0;

	nBin = conf->nBin;

	I0 = 0;
	X = 0;
	Y = 0;
	time = 0;
}

/* ******************************************************************** */
/** fringeParam::calculate(NPOI_FRAME *data)
    Calculates power and base intensity across one record of data	*/
/* ******************************************************************** */
void fringeParam::calculate(NPOI_FRAME *data) {
	int	iBin;
	float	u;
	float	v;

	I0 = 0;
	X = 0;
	Y = 0;
	time = data->fringeTime;

	for(iBin = 0; iBin < nBin; iBin++) {
		I0 +=
			data->photonCounts[iSpec][iChan][iBin];
	}

	I0 /= nBin;

	for(iBin = 0; iBin < nBin; iBin++) {
		u = data->photonCounts[iSpec][iChan][iBin];
		u -= I0;

		v = (2 * PI * k) * (iBin - (nBin - 1) / 2);
		v /= nBin;

		X += u * cos(v);
		Y += u * sin(v);
	}
}
