/* ******************************************************************** */
/** fringeSpectra.h							*/
/** 2002-07-02 Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _FRINGESPECTRA_H
#define _FRINGESPECTRA_H

class fringeSpectra {
 public:
  /*  fringeSpectra(float, int, float); */
  fringeSpectra(configure *pConf, int iInterp, int iNumFreq ) ;
  ~fringeSpectra();

  int iSpec;
  int iChan;

  /* **************************************************** */
  /* calculate() assumes fringe is pointed to something	*/
  /* valid.						*/
  /*							*/
  /* calculate(NPOI_FRAME *) will rebuild fringe even if	*/
  /* it already exists.					*/
  /* **************************************************** */
  void calculate();
  void calculate(NPOI_FRAME *);
  void plotFS(void) ;
  void save( void ) ;

  /* **************************************************** */
  /* Dimension: k->n    Interpolated spectrum		*/
  /* **************************************************** */

  float	*spectra;

  /* **************************************************** */
  /* Dimensions::nFrame * k->n  pointer to the raw data   */
  /* **************************************************** */

 private: 
  float calcI0( unsigned char  *piBins) ;
  void calc1(int iNumBins, unsigned char *piBins, float fCounts) ;
  float sinc( float fX ) ;

  configure *pConf ;
  int nFrame;
  int nBin;

  int iNumFreqs ;  // number of fringe frequencies calculated
  int iInterp ; // interval between fringe frequencies

  double dfI0 ;           //  storage for mean counts per frame
  double *pdfSpectrum ;  //  storage for fringe spectrum

};

#endif
