/* =======================================================================
   fs.C

   make a fringe spectrum.  this will become the template for the 
   main data reduction program.

   2002-07-03 Dan Driscoll -- function created
   2002-08-19 David Mozurkewich -- removed plot device type
   2002-08-20 David Mozurkewich -- added configuration class
   removed loop over multiple wavelengths.
   
=======================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <libgen.h>
#include <npoi_container.h>
#include "wavelength.h"
#include "iter.h"
#include "configure.h"
#include "fringeSpectra.h"
#define INTERP    8    // number of points / number of indep points
#define	NK      256    // Number of points to evaluate V^2 

int bPlot = 0 ;

/* ******************************************************************** */
int main(int iArgs, char **pcArg)
{
  NPOI_FRAME *pData ;       // just the raw data
  fringeSpectra *spectra ; // holds calculated fringe spectrum
  configure *pConf ;
  int iNumChans, *piChanList, iChan ;

  /* =========================================================
     part 1.  User interface.  Get user supplied parameters
     and store them where they can be accessed where needed.
     ==========================================================*/

  pConf = new configure ( iArgs, pcArg ) ;
  printf ( "FS:  configuration complete\n" ) ;

  /* =========================================================
     Part 3.  Initialize

     read wavelength list from wavelength file
     create an instance of the fringeSpectra class 

     Create one plot device.
     =========================================================*/

  spectra = new fringeSpectra(pConf, INTERP, NK);
  spectra->iSpec = pConf->getSpect() ;
  printf ( "spectra configured for spectrograph %2d\n", spectra->iSpec ) ;
  iNumChans = pConf->getNumChans() ;
  piChanList = pConf->getChanList() ;

  /* ==========================================================
     Part 4.  Process Data
     ==========================================================*/

  pData = pConf->getData() ;

  for (iChan = 0 ; iChan < iNumChans ; iChan++ )
    {
      printf ( "processing channel %3d\n", piChanList[iChan] ) ;
      spectra->iChan = piChanList[iChan] ;
      spectra->calculate(pData);

      /* Plot the spectrum */
      if ( bPlot )
	{
	  spectra->plotFS() ;
	  printf ( "plot devices closed\n" ) ;
	}
      spectra->save() ;
      printf ( "fringe spectrum for Channel %2d saved\n", piChanList[iChan] ) ;
    }

  printf ( "ready to release memory\n" ) ;
  delete spectra;
  return (0) ;
}
 
