/* ******************************************************************** */
/* grframe.C								*/
/* 2002-07-30 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <assert.h>
#include <npoi_container.h>

extern "C" {
#include <cpgplot.h>
}

#include "groupDelay.h"
#include "wavelength.h"
#include "minmax.h"

int main(int argc, char **argv) {
	NPOI_CONTAINER	*d;
	fringeParam	*fp;
	groupDelay	*gd;
	wavelength	*wave;
	int		iFrame;
	int		iSpec;
	int		iChan;
	int		nChan;
	float		k;
	int		intr;
	int		i;
	float		maxG;
	float		x_pts[1000];

	if(argc < 9) {
		fprintf(stderr, "Usage: %s INFILE WAVEFILE DEVICE FRAME SPEC K",
				argv[0]);
		fprintf(stderr, " INTEGRATION\n");
		exit(1);
	}

	d = new NPOI_CONTAINER(argv[1]);
	if(d->config == NULL) {
		fprintf(stderr, "No data loaded\n");
		exit(1);
	}

	nChan = d->config->nChan;

	wave = new wavelength(d->config);
	wave->load(argv[2]);

	iFrame = atoi(argv[5]);
	iSpec = atoi(argv[6]);

	k = atof(argv[7]);

	intr = atoi(argv[8]);

	gd = new groupDelay[intr](d->config, -10000.0, 1000, 20.0);

	for(i = 0; i < 1000; i++) {
		x_pts[i] = (i * 20) - 10000;
	}

	for(i = 0; i < intr; i++) {
		gd[i].k = k;
		gd[i].iSpec = iSpec;

		gd[i].wave = wave;

		fp = new fringeParam[nChan](d->config);
		for(iChan = 0; iChan < nChan; iChan++) {
			fp[iChan].iSpec = iSpec;
			fp[iChan].iChan = iChan;
			fp[iChan].k = k;

			fp[iChan].calculate(&(d->frames[iFrame + i]));
		}

		gd[i].fringe = fp;

		gd[i].calculate();

		gd[i].wave = NULL;

		if(i == 0 || gd[i].maxG > maxG) {
			maxG = gd[i].maxG;
		}
	}

	cpgopen(argv[3]);
	cpgsch(2.5);

	for(i = 0; i < intr; i++) {
		if(i % 3 == 0) {
			cpgsubp(1, 3);
		}

		if(i == 0) {
			cpgenv(-10000, 10000, 0, maxG, 0, -1);
			cpgaxis("N", -10000, 0, 10000, 0, -10000, 10000, 0, 0, 0, 1.0, 0.5,
					1.2, 0);
		} else {
			cpgenv(-10000, 10000, 0, maxG, 0, -2);
		}

		cpgline(1000, x_pts, gd[i].G);
	}

	cpgclos();

	exit(0);
}
