/* ******************************************************************** */
/* gdRecord.C								*/
/* 2002-07-31 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <assert.h>
#include <curses.h>
#include <getopt.h>
#include <npoi_container.h>

extern "C" {
#include <cpgplot.h>
}

#include "minmax.h"
#include "groupDelayZeroPhase.h"
#include "wavelength.h"
#include "histobin.h"
#include "plotter.h"

#define STARTD	-10000.0
#define INCD	20.0
#define ND	1000
#define ENDD	INCD * ND + STARTD
#define NBIN	40
#define ALPHA	-0.01
#define SF	2.0

groupDelayZeroPhase *calculateGD(NPOI_CONTAINER *, wavelength *, int, int, int, float, int);

/* ******************************************************************** */
int main(int argc, char **argv) {
	NPOI_CONTAINER		*d;
	wavelength		*wave;
	groupDelayZeroPhase	*gd;
	histobin		*histG;
	histobin		*histD;
	int			iSpec;
	int			iFrame;
	int			fFrame;
	int			nFrame;
	unsigned long		first_ts;
	unsigned long		delta_ts;
	float			k;
	float			maxG;
	char			buf[BUFSIZ];
	int			dot;

	if(argc < 9) {
		fprintf(stderr, "Usage: %s INFILE WAVEFILE DEVICEPREFIX FFRAME NFRAME SPEC K DOT\n",
				argv[0]);
		exit(1);
	}

	d = new NPOI_CONTAINER(argv[1]);
	if(d->config == NULL) {
		fprintf(stderr, "No data loaded\n");
		exit(1);
	}

	nFrame = d->config->nFrame;

	wave = new wavelength(d->config);
	wave->load(argv[2]);

	fFrame = atoi(argv[4]);
	nFrame = atoi(argv[5]);
	iSpec = atoi(argv[6]);
	k = atof(argv[7]);
	dot = atoi(argv[8]);

	first_ts = d->config->firstTS;
	delta_ts = d->config->lastTS - first_ts;

	sprintf(buf, "%s_dplot.ps/cps", argv[3]);
	cpgopen(buf);

	cpgenv(0, delta_ts, STARTD, ENDD, 0, 0);
	cpglab("\0", "d", "d at max G");

	gd = calculateGD(d, wave, fFrame, nFrame, iSpec, k, dot);

	cpgclos();

	for(iFrame = 0; iFrame < nFrame; iFrame++)
		if(iFrame == 0 || gd[iFrame].maxG > maxG)
			maxG = gd[iFrame].maxG;

	histG = new histobin(NBIN, 0, maxG);
	histD = new histobin(NBIN, STARTD, ENDD);

	sprintf(buf, "%s_gplot.ps/cps", argv[3]);
	cpgopen(buf);
	cpgenv(0, delta_ts, 0, maxG, 0, 0);
	cpglab("\0", "G", "G at max G");

	for(iFrame = 0; iFrame < nFrame; iFrame++) {
		cpgswin(0, delta_ts, 0, maxG);
		cpgpt1(gd[iFrame].time - first_ts, gd[iFrame].maxG, dot);

		histG->hist(gd[iFrame].maxG);
		histD->hist(gd[iFrame].maxD);
	}

	cpgclos();

	sprintf(buf, "%s_dhist.ps/cps", argv[3]);
	cpgopen(buf);
	cpgenv(0, findMax(NBIN, histD->cts) * SF, STARTD, ENDD, 0, 0);
	pbin_horizontal(NBIN, histD->bins, histD->cts);
	cpgclos();

	sprintf(buf, "%s_ghist.ps/cps", argv[3]);
	cpgopen(buf);
	cpgenv(0, findMax(NBIN, histG->cts) * SF, 0, maxG, 0, 0);
	pbin_horizontal(NBIN, histG->bins, histG->cts);
	cpgclos();

	exit(0);
}

/* ******************************************************************** */
groupDelayZeroPhase *calculateGD(
	NPOI_CONTAINER	*d,
	wavelength	*wave,
	int		fFrame,
	int		nFrame,
	int		iSpec,
	float		k,
	int		dot)
{
	groupDelayZeroPhase	*gd;
	fringeParam		*fp;
	int			iFrame;
	int			iChan;
	int			nChan;

	nChan = d->config->nChan;

	gd = new groupDelayZeroPhase[nFrame](d->config, STARTD, ND, INCD);

	for(iFrame = 0; iFrame < nFrame; iFrame++) {
		gd[iFrame].k = k;
		gd[iFrame].iSpec = iSpec;

		gd[iFrame].wave = wave;

		fp = new fringeParam[nChan](d->config);
		for(iChan = 0; iChan < nChan; iChan++) {
			fp[iChan].iSpec = iSpec;
			fp[iChan].iChan = iChan;
			fp[iChan].k = k;

			fp[iChan].calculate(&(d->frames[fFrame + iFrame]));
		}
		gd[iFrame].fringe = fp;

		gd[iFrame].calculate();
		gd[iFrame].findMaxG();

		gd[iFrame].wave = NULL;

		cpgpt1(gd[iFrame].time - gd[0].time, gd[iFrame].maxD0p, dot);
	}

	delete [] fp;

	return gd;
}
