/* ******************************************************************** */
/** groupDelay.C							*/
/** 2002-07-03 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <math.h>
#include "groupDelay.h"

/* ******************************************************************** */
/** groupDelay::groupDelay(float dStart, int dN, float dInc)
    Constructor, zeros whole structure.					*/
/* ******************************************************************** */
groupDelay::groupDelay(float dStart, int dN, float dInc) {
	d = new iter(dStart, dN, dInc);

	k = 0;
	iSpec = 0;

	nChan = 0;
	nBin = 0;

	wave = NULL;
	fringe = NULL;

	R = NULL;
	I = NULL;
	phase = NULL;

	maxG = 0;
	maxD = 0;
	phaseAtMaxD = 0;
}

/* ******************************************************************** */
/** groupDelay::groupDelay(NPOI_CONFIG *conf, float dStart, int dN,
    float dInc)
    Constructor, zeros whole structure and sets appropriate values from
    conf structure.							*/
/* ******************************************************************** */
groupDelay::groupDelay(NPOI_CONFIG *conf, float dStart, int dN, float dInc) {
	d = new iter(dStart, dN, dInc);

	k = 0;
	iSpec = 0;

	nChan = conf->nChan;
	nBin = conf->nBin;

	wave = NULL;
	fringe = NULL;

	R = NULL;
	I = NULL;
	phase = NULL;

	maxG = 0;
	maxD = 0;
	phaseAtMaxD = 0;
}

/* ******************************************************************** */
/** groupDelay::~groupDelay()
    Destructor.								*/
/* ******************************************************************** */
groupDelay::~groupDelay() {
	if(d)		{ delete d;		}
	if(wave)	{ delete wave;		}
	if(fringe)	{ delete fringe;	}
	if(R)		{ delete [] R;		}
	if(I)		{ delete [] I;		}
	if(phase)	{ delete [] phase;	}
}

/* ******************************************************************** */
void groupDelay::calculate() {
	int	iChan;
	int	iD;
	float	fD;
	float	t;
	float	re;
	float	im;

	if(R)		{ delete [] R;		}
	if(I)		{ delete [] I;		}
	if(G)		{ delete [] G;		}
	if(phase)	{ delete [] phase;	}

	R = new float[d->n];
	I = new float[d->n];
	G = new float[d->n];
	phase = new float[d->n];

	d->reset();

	while(d->next()) {
		iD = d->idx;
		fD = d->val;

		time = fringe[0].time;

		R[iD] = 0;
		I[iD] = 0;

		for(iChan = 0; iChan < nChan; iChan++) {
			t = 2 * PI * fD / wave->center[iSpec][iChan];

			re = cos(t);
			im = sin(t);

			R[iD] += (re * fringe[iChan].X);
			R[iD] -= (im * fringe[iChan].Y);

			I[iD] += (re * fringe[iChan].Y);
			I[iD] += (im * fringe[iChan].X);
		}

		G[iD] = R[iD] * R[iD] + I[iD] * I[iD];
		phase[iD] = atan2(I[iD], R[iD]);
	}

	findMaxG();
}

/* ******************************************************************** */
void groupDelay::calculate(NPOI_FRAME *data) {
	int	iChan;

	if(!fringe) {
		fringe = new fringeParam[nChan]();

		for(iChan = 0; iChan < nChan; iChan++) {
			fringe[iChan].iSpec = iSpec;
			fringe[iChan].iChan = iChan;
			fringe[iChan].k = k;

			fringe[iChan].nBin = nBin;

			fringe[iChan].calculate(data);
		}
	}

	if(!wave) {
		fprintf(stderr, "groupDelay.wave not filled\n");

		return;
	}

	calculate();
}

/* ******************************************************************** */
void groupDelay::findMaxG() {
	int	iD;
	int	tiD;

	d->reset();

	while(d->next()) {
		iD = d->idx;

		if(iD == 0 || G[iD] > maxG) {
			maxG = G[iD];
			maxD = d->val;
			phaseAtMaxD = phase[iD];

			tiD = iD;
		}
	}
}
