/* ******************************************************************** */
/** groupDelay.h							*/
/** 2002-07-02 Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _GROUPDELAY_H
#define _GROUPDELAY_H

#include <npoi_config.h>
#include <npoi_frame.h>
#include "fringeParam.h"
#include "wavelength.h"
#include "iter.h"

class groupDelay {
	public:
		groupDelay(float, int, float);
		groupDelay(NPOI_CONFIG *, float, int, float);
		~groupDelay();

		iter	*d;

		float	k;
		int	iSpec;

		int	nChan;
		int	nBin;

		/* **************************************************** */
		/* calculate() assumes fringe and wave are pointed to	*/
		/* something useful.					*/
		/*							*/
		/* calculate(NPOI_FRAME *) will rebuild fringe and wave	*/
		/* even if they already exist.				*/
		/* **************************************************** */
		void	calculate();
		void	calculate(NPOI_FRAME *);

		/* **************************************************** */
		/* findMaxG() fills maxG, maxD, phaseAtMaxD, etc.  If	*/
		/* usePhaseToFindMax is set, it uses a trickier method	*/
		/* of finding the maximum.				*/
		/* **************************************************** */
		void	findMaxG();

		/* **************************************************** */
		/* Dimensions:						*/
		/*	wave = 1					*/
		/*	fringe = nChan					*/
		/* **************************************************** */
		wavelength	*wave;
		fringeParam	*fringe;

		/* **************************************************** */
		/* R, I, G, phase dimensions: d->n			*/
		/* **************************************************** */
		float	*R;	/* Real group delay			*/
		float	*I;	/* Imaginary group delay		*/
		float	*G;	/* R^2 + I^2, here for your convenience	*/	
		float	*phase;	/* arctan(I / R), again convenience	*/

		unsigned long	time;	/* timestamps for this point	*/

		float	maxG;	/* Maximum value of G found		*/
		float	maxD;	/* Value of d where maxG is found	*/
				/* startD <= maxD < (startD + nD*incD)	*/
		float	phaseAtMaxD;
				/* arctan(I / R) where maxG is found	*/
};

#endif
