/* ******************************************************************** */
/** groupDelayMerit.C							*/
/** 2002-08-01 Dan Driscoll						*/
/* ******************************************************************** */

#include <math.h>
#include "groupDelayMerit.h"

/* ******************************************************************** */
/** groupDelayMerit::groupDelayMerit(float dStart, int dN, float dInc)
    Constructor, zeros whole structure.					*/
/* ******************************************************************** */
groupDelayMerit::groupDelayMerit(float dStart, int dN, float dInc) :
groupDelayZeroPhase(dStart, dN, dInc)
{
	gd = NULL;
	nGD = 0;
	iGD = 0;

	weightPower = 0;
	weightStep = 0;
	weightDeriv = 0;

	meritPower = 0;
	meritStep = 0;
	meritDeriv = 0;
	merit = 0;
}

/* ******************************************************************** */
/** groupDelayMerit::groupDelayMerit(NPOI_CONFIG *conf, float dStart,
    int dN, float dInc)
    Constructor, zeros whole structure and sets appropriate values from
    conf structure.							*/
/* ******************************************************************** */
groupDelayMerit::groupDelayMerit(NPOI_CONFIG *conf, float dStart, int dN,
		float dInc) : groupDelayZeroPhase(conf, dStart, dN, dInc)
{
	gd = NULL;
	nGD = 0;
	iGD = 0;

	weightPower = 0;
	weightStep = 0;
	weightDeriv = 0;

	meritPower = 0;
	meritStep = 0;
	meritDeriv = 0;
	merit = 0;
}

/* ******************************************************************** */
void groupDelayMerit::meritPowerCalc() {
	if(maxG0p > GDmedianG) {
		meritPower = 1;
	} else {
		meritPower = maxG0p / GDmedianG;
	}
}

/* ******************************************************************** */
void groupDelayMerit::meritStepCalc() {
	float	slope;
	float	guess;

	if(iGD == 0 || iGD == nGD - 1) {
		weightStep = 0;

		meritStep = 0;
		return;
	}

	slope = (gd[iGD + 1].maxD0p - gd[iGD - 1].maxD0p) /
		(gd[iGD + 1].time - gd[iGD - 1].time);
	
	guess = gd[iGD - 1].maxD0p + slope * (gd[iGD].time - gd[iGD - 1].time);

	meritStep = (fabs(guess - gd[iGD].maxD0p) < meritStepThreshold);
}

/* ******************************************************************** */
void groupDelayMerit::meritDerivCalc() {
	weightDeriv = 0;
	meritDeriv = 0;
}

/* ******************************************************************** */
void groupDelayMerit::meritCalc() {
	float	scale;

	meritPowerCalc();
	meritStepCalc();
	meritDerivCalc();
	
	scale = weightPower + weightStep + weightDeriv;

	if(scale == 0) {
		merit = 0;
		return;
	}

	weightPower /= scale;
	weightStep /= scale;
	weightDeriv /= scale;

	merit = meritPower * weightPower +
		meritStep * weightStep +
		meritDeriv * weightDeriv;
}
