/* ******************************************************************** */
/** groupDelayMerit.h							*/
/** 2002-08-01 Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _GROUPDELAYMERIT_H
#define _GROUPDELAYMERIT_H

#include <npoi_config.h>

#include "groupDelayZeroPhase.h"

class groupDelayMerit : public groupDelayZeroPhase {
	public:
		groupDelayMerit(float, int, float);
		groupDelayMerit(NPOI_CONFIG *, float, int, float);

		/* **************************************************** */
		/* merit__ functions calculate the merit of this point	*/
		/* in the array according to several different		*/
		/* measures.  Each measure is summed according to the	*/
		/* weights below.					*/
		/* **************************************************** */
		void	meritPowerCalc();
		void	meritStepCalc();
		void	meritDerivCalc();
		void	meritCalc();

		/* **************************************************** */
		/* gd is used as a way to get at adjacent points in the	*/
		/* groupDelay scale.  nGD is the total length of the gd	*/
		/* array, and iGD is this index.			*/
		/* **************************************************** */
		groupDelayMerit	*gd;
		int		nGD;
		int		iGD;
		/* **************************************************** */
		/* The following variables MUST be filled beforehand.	*/
		/* Each relates to the whole gd array.			*/
		/* **************************************************** */
		float	GDmedianG;
		float	meritStepThreshold;

		/* **************************************************** */
		/* weight___ values represent weight each merit func	*/
		/* has on the overall merit value.  Values need not sum	*/
		/* to 1, but will be scaled such that they do.		*/
		/* **************************************************** */
		float	weightPower;
		float	weightStep;
		float	weightDeriv;

		float	meritPower;
		float	meritStep;
		float	meritDeriv;
		float	merit;	/* Usefulness of point, 0 <= merit <= 1	*/
};

#endif
