/* ******************************************************************** */
/** groupDelayZeroPhase.C						*/
/** 2002-08-01 Dan Driscoll						*/
/* ******************************************************************** */

#include <math.h>
#include "groupDelayZeroPhase.h"

/* ******************************************************************** */
/** groupDelayZeroPhase::groupDelayZeroPhase(float dStart, int dN,
    float dInc)
    Constructor, zeros whole structure.					*/
/* ******************************************************************** */
groupDelayZeroPhase::groupDelayZeroPhase(float dStart, int dN, float dInc) :
groupDelay(dStart, dN, dInc)
{
	maxG0p = 0;
	maxD0p = 0;
	phaseAtMaxD0p = 0;
}

/* ******************************************************************** */
/** groupDelayZeroPhase::groupDelayZeroPhase(NPOI_CONFIG *conf,
    float dStart, int dN, float dInc)
    Constructor, zeros whole structure and sets appropriate values from
    conf structure.							*/
/* ******************************************************************** */
groupDelayZeroPhase::groupDelayZeroPhase(NPOI_CONFIG *conf, float dStart,
		int dN, float dInc) : groupDelay(conf, dStart, dN, dInc)
{
	maxG0p = 0;
	maxD0p = 0;
	phaseAtMaxD0p = 0;
}

/* ******************************************************************** */
void groupDelayZeroPhase::findMaxG() {
	int	iD;

	groupDelay::findMaxG();

	/* ************************************************************ */
	/* NOTE!  This algorithm works ONLY when phase increases with	*/
	/* d.  Find a better [cheaper?] hunting algorithm for other	*/
	/* data!							*/
	/* ************************************************************ */
	iD = d->index(maxD);

	if(phase[iD] > 0) {
		while(phase[iD] > 0 && iD > 0) {
			iD--;
		}

		if(fabs(phase[iD]) > fabs(phase[iD + 1])) {
			iD++;
		}
	} else if(phase[iD] < 0) {
		while(phase[iD] < 0 && iD < d->n) {
			iD++;
		}

		if(fabs(phase[iD]) > fabs(phase[iD - 1])) {
			iD--;
		}
	}

	maxG0p = G[iD];
	maxD0p = d->value(iD);
	phaseAtMaxD0p = phase[iD];
}
