/* ******************************************************************** */
/** histobin.C								*/
/** 2002-07-30 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <unistd.h>
#include <math.h>

#include "histobin.h"

/* ******************************************************************** */
histobin::histobin(int enBin, float eleft, float eright) {
	int	iBin;

	nBin = enBin;
	left = eleft;
	right = eright;

	cts = new float[nBin];
	bins = new float[nBin];

	for(iBin = 0; iBin < nBin; iBin++) {
		cts[iBin] = 0;
		bins[iBin] = left + (iBin * (right - left) / nBin);
	}
}

/* ******************************************************************** */
histobin::~histobin() {
	delete [] cts;
	delete [] bins;
}

/* ******************************************************************** */
void histobin::hist(int size, float *data) {
	int	idx;

	for(idx = 0; idx < size; idx++) {
		cts[(int)((data[idx] - left) * ((nBin - 1) / (right - left)))]++;
	}
}

/* ******************************************************************** */
void histobin::hist(int size, float *data, float alpha) {
	int	idx;
	int	iBin;

	for(idx = 0; idx < size; idx++) {
		for(iBin = 0; iBin < nBin; iBin++) {
			cts[iBin] += pow(E, alpha *
				fabs(data[idx] - ((iBin * ((right - left) / nBin)) + left)));
		}
	}
}
/* ******************************************************************** */
void histobin::hist(float data) {
	cts[(int)((data - left) * ((nBin - 1) / (right - left)))]++;
}

/* ******************************************************************** */
void histobin::hist(float data, float alpha) {
	int	iBin;
	
	for(iBin = 0; iBin < nBin; iBin++) {
		cts[iBin] += pow(E, alpha *
			fabs(data - ((iBin * ((right - left) / nBin)) + left)));
	}
}

/* ******************************************************************** */
float histobin::leftVal(int idx) {
	return (left + ((right - left) / nBin) * idx);
}

/* ******************************************************************** */
float histobin::rightVal(int idx) {
	return leftVal(idx + 1);
}

/* ******************************************************************** */
float histobin::centerVal(int idx) {
	return (leftVal(idx) + rightVal(idx)) / 2;
}
