/* ******************************************************************** */
/** iter.C								*/
/** 2002-08-07 Dan Driscoll						*/
/* ******************************************************************** */

#include <string.h>
#include <stdlib.h>
#include "iter.h"

/* ******************************************************************** */
/** iter::iter(char *initStr)
   Initialize this iter with an initialization string.

   Format is:
   	"start-end:n@inc!" where only three elements are required and
	the trailing "!" is optional BUT ALL OTHER PUNCTUATION IS
	NECESSARY!

	For example:
		"0-10:2@" sets iterations at 0 and 5
		"0-10:2@!" sets iterations at 0 and 10

		"0-:2@0.5" sets iterations at 0, and 0.5
									*/
/* ******************************************************************** */
iter::iter(char *initStr) {
	char	bStart = 0;
	char	bEnd = 0;
	char	bN = 0;
	char	bInc = 0;
	char	bBang = 0;
	char	buf[BUFSIZ];
	char	*str;
	int	len;
	int	i;

	str = initStr;

	/* ************************************************************ */
	len = strchr(str, '-') - str;
	if(len > 1) {
		memcpy(buf, str, len);
		buf[len] = '\0';
		start = atof(buf);
		bStart = 1;
	}
	str = strchr(str, '-') + 1;

	/* ************************************************************ */
	len = strchr(str, ':') - str;
	if(len > 1) {
		memcpy(buf, str, len);
		buf[len] = '\0';
		end = atof(buf);
		bEnd = 1;
	}
	str = strchr(str, ':') + 1;

	/* ************************************************************ */
	len = strchr(str, '@') - str;
	if(len > 1) {
		memcpy(buf, str, len);
		buf[len] = '\0';
		n = atoi(buf);
		bN = 1;
	}
	str = strchr(str, '@') + 1;

	/* ************************************************************ */
	if(strchr(str, '!')) {
		len = strchr(str, '!') - str;
	} else {
		len = strlen(str);
	}

	if(len > 1) {
		memcpy(buf, str, len);
		buf[len] = '\0';
		inc = atof(buf);
		bInc = 1;
	}

	/* ************************************************************ */
	if(strchr(str, '!')) {
		bBang = 1;
	}

	/* ************************************************************ */
	if(bStart + bEnd + bN + bInc < 3) {
		fprintf(stderr, "ERROR: Your formatting string has too few elements!\n");
		bStart = bEnd = bN = bInc = bBang = 0;
		return;
	} else if(bStart + bEnd + bN + bInc > 3) {
		fprintf(stderr, "ERROR: Your formatting string has too many elements!\n");
		bStart = bEnd = bN = bInc = bBang = 0;
		return;
	}

	/* ************************************************************ */
	if(bStart == 0) {
		if(bBang) {
			start = end - ((n + 1) * inc);
		} else {
			start = end - (n * inc);
		}
	} else if(bEnd == 0) {
		if(bBang) {
			end = start + ((n + 1) * inc);
		} else {
			end = start + (n * inc);
		}
	} else if(bN == 0) {
		if(bBang) {
			n = (int)((end - start) / inc) + 1;
		} else {
			n = (int)((end - start) / inc);
		}
	} else if(bInc == 0) {
		if(bBang) {
			inc = (end - start) / n;
		} else {
			inc = (end - start) / (n + 1);
		}
	}

	indices = new float[n];
	for(i = 0; i < n; i++) {
		indices[i] = start + (i * inc);
	}

	idx = 0;
	val = start;
}

/* ******************************************************************** */
/** iter::iter(float start, int n, float inc)				*/
/* ******************************************************************** */
iter::iter(float eStart, int eN, float eInc) {
	start = eStart;
	n = eN;
	inc = eInc;

	end = start + (n * inc);
}

/* ******************************************************************** */
/** iter::~iter()							*/
/* ******************************************************************** */
iter::~iter() {
	delete [] indices;
}

/* ******************************************************************** */
/** iter::value(int index)						*/
/* ******************************************************************** */
float iter::value(int index) {
	return start + inc * index;
}

/* ******************************************************************** */
/** iter::index(float value)						*/
/* ******************************************************************** */
int iter::index(float value) {
	return (int)((value - start) / inc);
}

/* ******************************************************************** */
/** iter::next()							*/
/* ******************************************************************** */
char iter::next() {
	if(idx < (n - 1)) {
		idx++;
		val = value(idx);

		return 1;
	} else {
		return 0;
	}
}

/* ******************************************************************** */
/** iter::reset()							*/
/* ******************************************************************** */
void iter::reset() {
	idx = -1;
	val = start;
}
