#include <stdio.h>
#include <stdlib.h>
#include <string.h>

extern "C" {
  #include "cpgplot.h"
}

#define WHITE 1
#define Red   2
#define GREEN 3
#define BLUE  4

static int iLineWidth = 3 ;
static float fCharHeight = 1.5 ;
static float fCoord = 0.5 ;
static float fJusty = 0.5 ;
static float fDisp  = 1.5 ;
static char pcTitle[BUFSIZ] ;
static char pcXLabel[BUFSIZ] ;
static char pcYLabel[BUFSIZ] ;
static int iPlotDev = -5 ;

void setLabels ( char *pcX, char *pcY, char *pcTop )
{
  strncpy( pcXLabel, pcX,   BUFSIZ ) ;
  strncpy( pcYLabel, pcY,   BUFSIZ ) ;
  strncpy( pcTitle,  pcTop, BUFSIZ ) ;
}


void plot2( int iPts, int iTerp, float *pfX, float *pfY, float *pfFit )
{
  float fMin, fMax, pfXBar[2]={0.,0.}, pfYBar[2]={0.,0.} ;
  int i, iK ;

  /* Open plot device, if necessary */

  if ( iPlotDev == -5 )
    iPlotDev = cpgopen("?") ;
  else
    cpgslct( iPlotDev ) ;

  cpgpage() ;
  cpgslw ( iLineWidth ) ;
  cpgsch ( fCharHeight ) ;
  cpgsci ( WHITE ) ;


  /* set the full sized viewport for labels. */

    cpgsvp  ( 0.20, 0.9, 0.15, 0.85 ) ;

    /* Title */

    fDisp = 1.5 ;
    cpgsch ( fCharHeight ) ;
    cpgmtxt ( "t", fDisp, fCoord, fJusty, pcTitle ) ;

    /* Left Axis Labels */

    fDisp = 5.0 ;
    cpgsch ( 0.75*fCharHeight ) ;
    cpgmtxt ( "l", fDisp, fCoord, fJusty, pcYLabel ) ;

    /* bottom label */

    fDisp = 3.0 ;
    cpgmtxt ( "b", fDisp, fCoord, fJusty, pcXLabel ) ;

    cpgsch ( 0.75*fCharHeight ) ;

    /* now set up the upper box */

    fMax = 0. ; 
    for ( iK = 0 ; iK < iPts ; iK++ )
      if ( pfY[iK] > fMax )
	fMax = pfY[iK] ;

    cpgsvp  ( 0.20, 0.9, 0.50, 0.85 ) ;
    cpgswin ( 0.0, pfX[iPts-1], 0.0, fMax ) ;
    cpgbox  ( "BCST", 0.0, 0, "BCNSTV", 0.0, 0 ) ;

    /* The data */

    cpgsch(1.5);
    cpgsci(1);
    cpgline(iPts, pfX, pfY);

    /* and the fit */

    cpgsci(2) ;
    cpgline(iPts, pfX, pfFit);
    cpgsci(1) ;


    /* Now the lower box has the residuals */

    fMin = 0. ; 
    fMax = 0. ;
    for ( i = 0 ; i < iPts ; i++ )
      {
	pfFit[i] = pfY[i] - pfFit[i] ;
	if ( pfFit[i] < fMin )
	  fMin = pfFit[i] ;
	else if ( pfFit[i] > fMax )
	  fMax = pfFit[i] ;
      }

    cpgsvp  ( 0.20, 0.9, 0.15, 0.50 ) ;
    cpgswin ( 0.0, pfX[iPts-1], fMin, fMax ) ;
    cpgbox  ( "ABCNST", 0.0, 0, "BCNSTV", 0.0, 0 ) ;

    cpgline(iPts, pfX, pfFit);

    /* Plot a point at each integer value */

    cpgsci(WHITE) ;
    for ( iK = 0 ; iK < iPts ; iK+=iTerp )
      cpgpt ( 1, pfX+iK, pfFit+iK, 4 ) ;
    cpgsci(1) ;

    /* For some reason, I cannot draw the X-axis, so I will do it by hand */

    cpgsci(WHITE ) ;
    pfXBar[1] = pfX[iPts-1] ;
    cpgline( 2, pfXBar, pfYBar ) ;

}


