/* =======================================================================
   plotData.C

   Fit the fringe spectra

   2002-08-21 David Mozurkewich -- function created
   
=======================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <libgen.h>
#include <math.h>
#include <string.h>
extern "C" {
#include <cpgplot.h>
}

#define PI  3.1415926535897932385
#define	NK	320	/* Number of points to interpolat  */

typedef struct{
  float fA ;
  float fB0 ;
  float fB1 ;
  float fk1 ;
  int iPeaks ;
  float *pfFreq ;
  float *pfA ;
} FIT ;

/*  =========== global variables ==================*/

static float pfK[NK], pfData[NK], pfFit[NK], pfX[65], pfRaw[65] ;
static char pcScanName[200] ;
static int iChan, iSpec ;
static float fWaveln, fI0 ;
static char *base(char *pcName) ;
static char pcBuf[1024] ;
static FILE *pFin, *pFout ;


char *pcPlotDev = "/xserv" ;
int iPlotDev ;

/*================= forward function definitions ===================== */

int readData( FILE *pF )  ;
void plots (int iPts, float *pfX, float *pfY, float *pfFit ) ;


/* from file plot2.C */

void setLabels ( char *pcX, char *pcY, char *pcTop ) ;
void plot2( int iPts, float *pfX, float *pfY, float *pfFit ) ;


/* ******************************************************************** */
int main(int iArgs, char **pcArg)
{
  /* =========================================================
     part 1.  User interface.  Get user supplied parameters
     and store them where they can be accessed where needed.
     ==========================================================*/

  /* =========================================================
     Part 2.  Initialize

     read wavelength list from wavelength file
     create an instance of the fringeSpectra class 

     Create one plot device.
     =========================================================*/

  pFin  = fopen ( pcArg[1], "r" ) ;
  if ( pFin != 0 )
    printf ( " file \"%s\" opened\n", "Results" ) ;
  else
    exit(1) ;
  /* ==========================================================
     Part 3.  Process Data
     ==========================================================*/

  iPlotDev = cpgopen(pcPlotDev);
  readData(pFin) ;
  plots ( 16, pfX, pfData, pfFit ) ;

  return (0) ;
}

int readData( FILE *pF ) 
{
  float fA,fB0, fB1 ;
  int iRet =  0 ;
  int i ;

  for ( i = 0 ; i < 16 ; i++ )
    {
      if ( strlen(fgets( pcBuf, 1024, pF )) < 10 ) 
	return ( iRet ) ;
      sscanf(pcBuf+ 29, "%f", &pfX[i] ) ;
      sscanf(pcBuf+ 36, "%f", &fI0 ) ;
      sscanf(pcBuf+ 48, "%f", &fA  ) ;
      sscanf(pcBuf+ 61, "%f", &fB0 ) ;
      sscanf(pcBuf+ 74, "%f", &fB1 ) ;
      sscanf(pcBuf+102, "%f", &pfData[i] );
    }

  return ( 1 ) ;
}

/** ============================================
    plotsData2

    plot the data and the fit
    ==============================================*/
void plots (int iPts, float *pfX, float *pfY, float *pfFit )
{
  float fXMax, fXMin, fYMax, fYMin ;
  int i ;

  /* plot V^2 vs wavelength */

  fYMin = pfY[0] ;
  fYMax = pfY[0] ; 
  fXMin = pfX[0] ;
  fXMax = pfX[0] ; 
  for ( i = 1 ; i < iPts ; i++ )
    {
      if ( pfY[i] > fYMax )
	fYMax = pfY[i] ;
      else if ( pfY[i] < fYMin )
	fYMin = pfY[i] ;
      if ( pfX[i] > fXMax )
	fXMax = pfX[i] ;
      else if ( pfX[i] < fXMin )
	fXMin = pfX[i] ;
    }
  cpgslct( iPlotDev ) ;
  cpgenv(fXMin, fXMax, fYMin, fYMax, 0, 0);
  cpglab("Wavelength (nm)", "V\\u2", " ");
  cpgsch(1.0);
  cpgsci(1);
  cpgpt(iPts, pfX, pfY, 4);
}

/** ===============================================
    char *base
    truncate file name to just data star and time
    ================================================*/
char *base( char *pcName )
{
  int i=0, iLen ;
  iLen = strlen(pcName) ;
  while ( i < iLen )
    {
      if ( (pcName[i]>='0')&&(pcName[i]<='9'))
	break ;
      i++ ;
    }
  printf ( "i=%d  iLen = %d\n", i, iLen ) ;
  if ( i == strlen(pcName) )
    return (pcName) ;
  else
    return (pcName+i) ;
}




