/* ******************************************************************** */
/** plotter.C								*/
/** 2002-07-19 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "plotter.h"


extern "C" {
#include <cpgplot.h>
}

/* ******************************************************************** */
void pbin_vertical(int nVal, float *absc, float *cts) {
	int	iVal;
	float	x1, x2, y1, y2;

	cpgqwin(&x1, &x2, &y1, &y2);

	cpgmove(absc[0], y1);

	for(iVal = 0; iVal < nVal - 1; iVal++) {
		cpgdraw(absc[iVal], cts[iVal]);
		cpgdraw(absc[iVal + 1], cts[iVal]);
	}

	cpgdraw(absc[nVal - 1], cts[nVal - 1]);
	cpgdraw(x2, cts[nVal - 1]);
	cpgdraw(x2, y1);
}

/* ******************************************************************** */
void pbin_horizontal(int nVal, float *absc, float *cts) {
	int	iVal;
	float	x1, x2, y1, y2;

	cpgqwin(&x1, &x2, &y1, &y2);

	cpgmove(x1, absc[0]);

	for(iVal = 0; iVal < nVal - 1; iVal++) {
		cpgdraw(cts[iVal], absc[iVal]);
		cpgdraw(cts[iVal], absc[iVal + 1]);
	}

	cpgdraw(cts[nVal - 1], absc[nVal - 1]);
	cpgdraw(cts[nVal - 1], y2);
	cpgdraw(x1, y2);
}

/* ******************************************************************** */
void plot_phase(int nVal, float *x, float *y) {
	int	iVal;
	float	x1, x2, y1, y2;

	cpgqwin(&x1, &x2, &y1, &y2);

	cpgbbuf();
	cpgmove(x[0], y[0]);
	for(iVal = 1; iVal < nVal; iVal++) {
		if(fabs(y[iVal - 1] - y[iVal]) < ((y2 - y1) * 0.5)) {
			cpgdraw(x[iVal], y[iVal]);
		} else {
			cpgmove(x[iVal], y[iVal]);
		}
	}
	cpgebuf();
}

/* ******************************************************************** */
void drawtick_top(float oldX, float newX) {
	float	x1, x2, y1, y2;

	cpgqwin(&x1, &x2, &y1, &y2);

	cpgsclp(0);

	cpgsci(0);
	cpgtick(x1, y2, x2, y2, (oldX - x1) / (x2 - x1), 0.8, 0, 0, 0, "\0");

	cpgsci(1);
	cpgpt1(oldX, y2, -1);

	cpgsci(2);
	cpgtick(x1, y2, x2, y2, (newX - x1) / (x2 - x1), 0.8, 0, 0, 0, "\0");

	cpgsclp(1);
}

/* ******************************************************************** */
void drawtick_right(float oldY, float newY) {
	float	x1, x2, y1, y2;

	cpgqwin(&x1, &x2, &y1, &y2);

	cpgsclp(0);

	cpgsci(0);
	cpgtick(x2, y1, x2, y2, (oldY - y1) / (y2 - y1), 0, 0.8, 0, 0, "\0");

	cpgsci(1);
	cpgpt1(x2, oldY, -1);

	cpgsci(2);
	cpgtick(x2, y1, x2, y2, (newY - y1) / (y2 - y1), 0, 0.8, 0, 0, "\0");

	cpgsclp(1);
}
