/* ******************************************************************** */
/** wavelength.C							*/
/** 2002-07-02 Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wavelength.h"

/* ******************************************************************** */
wavelength::wavelength() {
	nSpec = 0;
	nChan = 0;

	center = NULL;
	red = NULL;
	blue = NULL;
}

/* ******************************************************************** */
wavelength::wavelength(NPOI_CONFIG *conf) {
	center = NULL;
	red = NULL;
	blue = NULL;

	if(conf) {
		nSpec = conf->nSpec;
		nChan = conf->nChan;
	} else {
		nSpec = 0;
		nChan = 0;
	}
}

/* ******************************************************************** */
wavelength::~wavelength() {
	if(center) {
		for(int iSpec = 0; iSpec < nSpec; iSpec++)
			if(center[iSpec])
				delete [] center[iSpec];

		delete [] center;
	}

	if(blue) {
		for(int iSpec = 0; iSpec < nSpec; iSpec++)
			if(blue[iSpec])
				delete [] blue[iSpec];

		delete [] blue;
	}

	if(red) {
		for(int iSpec = 0; iSpec < nSpec; iSpec++)
			if(red[iSpec])
				delete [] red[iSpec];

		delete [] red;
	}
	if(fMap) {
		for(int iSpec = 0; iSpec < nSpec; iSpec++)
			if(fMap[iSpec])
				delete [] fMap[iSpec];

		delete [] fMap;
	}
	if(rMap) {
		for(int iSpec = 0; iSpec < nSpec; iSpec++)
			if(rMap[iSpec])
				delete [] rMap[iSpec];

		delete [] rMap;
	}
}

/* ******************************************************************** */
void wavelength::load(char *filename, int col) {
	FILE	*fp;

	if((fp = fopen(filename, "r")) == NULL) {
		perror("wavelength::load");
	}

	load(fp, col);

	fclose(fp);
}

/* ******************************************************************** */
void wavelength::load(FILE *fp, int col) {
	char	inbuf[BUFSIZ];
	int	iSpec;
	int	iChan;

	fgets(inbuf, BUFSIZ, fp);
	nSpec = atoi(inbuf);

	fgets(inbuf, BUFSIZ, fp);
	nChan = atoi(inbuf);

	center = new (float *)[nSpec];
	red = new (float *)[nSpec];
	blue = new (float *)[nSpec];

	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		center[iSpec] = new float[nChan];
		red[iSpec] = new float[nChan];
		blue[iSpec] = new float[nChan];
	}

	iSpec = 0;
	iChan = 0;

	while(!feof(fp) && (iSpec * nChan) + iChan < (nSpec * nChan)) {
		fgets(inbuf, BUFSIZ, fp);

		if(col == 1) {
			center[iSpec][iChan] = atof(inbuf);
			red[iSpec][iChan] = 0;
			blue[iSpec][iChan] = 0;
		} else {
			sscanf(inbuf, "%f\t%f\t%f\n", &(center[iSpec][iChan]),
					&(blue[iSpec][iChan]),
					&(red[iSpec][iChan]));
		}

		if(iChan < nChan - 1) {
			iChan++;
		} else {
			iSpec++;
			iChan = 0;
		}
	}

	buildMaps();
}

/* ******************************************************************** */
void wavelength::load(char *filename) {
	FILE	*fp;
	int	i;
	int	col = 0;
	char	buf[BUFSIZ];

	if((fp = fopen(filename, "r")) == NULL) {
		perror("wavelength::load");
	}

	fgets(buf, BUFSIZ, fp);	/* Skip first line, contains specs	*/
	fgets(buf, BUFSIZ, fp);	/* Skip second line, contains chans	*/
	fgets(buf, BUFSIZ, fp);
	for(i = 0; (unsigned int)i < strlen(buf); i++) {
		col += (buf[i] == '\t');
	}

	fseek(fp, 0, SEEK_SET);

	load(fp, col);

	fclose(fp);
}

/* ******************************************************************** */
void wavelength::save(char *filename, int col) {
	FILE	*fp;

	if((fp = fopen(filename, "w")) == NULL) {
		perror("wavelength::save");
	}

	save(fp, col);

	fclose(fp);
}

/* ******************************************************************** */
void wavelength::save(FILE *fp, int col) {
	int	iSpec;
	int	iChan;

	fprintf(fp, "%d\n", nSpec);
	fprintf(fp, "%d\n", nChan);

	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		for(iChan = 0; iChan < nChan; iChan++) {
			if(col == 1) {
				fprintf(fp, "%.2f\n", center[iSpec][iChan]);
			} if(col == 3) {
				fprintf(fp, "%.2f\t%.2f\t%.2f\n",
						center[iSpec][iChan],
						blue[iSpec][iChan],
						red[iSpec][iChan]);
			}
		}
	}
}

/* ******************************************************************** */
void wavelength::buildMaps() {
	float	minWave;
	int	minIdx;
	int	iSpec;
	int	iChan;
	int	i;

	fMap = new (int *)[nSpec];
	rMap = new (int *)[nSpec];
	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		fMap[iSpec] = new int[nChan];
		rMap[iSpec] = new int[nChan];
	}

	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		for(iChan = 0; iChan < nChan; iChan++) {
			minWave = center[iSpec][0];
			minIdx = 0;

			for(i = 0; i < nChan; i++) {
				if(iChan == 0) {
					if(center[iSpec][i] < minWave) {
						minWave = center[iSpec][i];
						minIdx = i;
					}
				} else {
					if(center[iSpec][i] < minWave &&
						center[iSpec][i] >
						center[iSpec][
						  rMap[iSpec][iChan - 1]
						])
					{
						minWave = center[iSpec][i];
						minIdx = i;
					}
				}
			}
	
			rMap[iSpec][iChan] = minIdx;
		}
	}

	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		for(iChan = 0; iChan < nChan; iChan++) {
			fMap[iSpec][rMap[iSpec][iChan]] = iChan;
		}
	}
}

/* ******************************************************************** */
void wavelength::buildData() {
	int	iSpec;

	center = new (float *)[nSpec];
	blue = new (float *)[nSpec];
	red = new (float *)[nSpec];

	fMap = new (int *)[nSpec];
	rMap = new (int *)[nSpec];

	for(iSpec = 0; iSpec < nSpec; iSpec++) {
		center[iSpec] = new float[nChan];
		blue[iSpec] = new float[nChan];
		red[iSpec] = new float[nChan];

		fMap[iSpec] = new int[nChan];
		rMap[iSpec] = new int[nChan];
	}
}
