/* ******************************************************************** */
/** wavelength.h							*/
/** 2002-07-02 Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _WAVELENGTH_H
#define _WAVELENGTH_H

#include <stdio.h>
#include <npoi_config.h>
#include <npoi_frame.h>

class wavelength {
	public:
		wavelength();
		wavelength(NPOI_CONFIG *);
		~wavelength();

		int	nSpec;
		int	nChan;

		/* **************************************************** */
		/* Read in data files.  File format:			*/
		/* First line: number of spectrometers\n		*/
		/* Second line: number of channels\n			*/
		/* Each subsequent line contains the channel center,	*/
		/* optionally followed by a tab, the blue bound,	*/
		/* another tab, the red bound, and a newline.		*/
		/*							*/
		/* load takes one or two arguments.  The first is	*/
		/* either the filename or a preopened filehandle.	*/
		/* The second column can be used to hardwire the number	*/
		/* of columns in the file.  If you happen to know	*/
		/* beforehand that your input file has only channel	*/
		/* center data, you can specify 1 as the second		*/
		/* argument.  Channel data with centers and bounds	*/
		/* would require a value of 3.  Simply not specifying	*/
		/* this value is the safest method as load will attempt	*/
		/* to determine it automatically.			*/
		/*							*/
		/* If there's ever any doubt, just use load(char *)	*/
		/* **************************************************** */
		void	load(char *);
		void	load(char *, int);
		void	load(FILE *, int);

		/* **************************************************** */
		/* Save data files in the same format as above.		*/
		/* **************************************************** */
		void	save(char *, int);
		void	save(FILE *, int);

		/* **************************************************** */
		/* buildMaps builds the forward and reverse mappings	*/
		/* for channel sorting and is called automatically	*/
		/* when load() is finished.				*/
		/* **************************************************** */
		void	buildMaps();

		/* **************************************************** */
		/* buildData builds raw data structures for center, red	*/
		/* blue, fMap, and rMap					*/
		/* **************************************************** */
		void	buildData();

		/* **************************************************** */
		/* center, red, and blue all have dimsensions nSpec *	*/
		/* nChan.						*/
		/* **************************************************** */
		float	**center;
		float	**red;
		float	**blue;

		/* **************************************************** */
		/* fMap and rMap have dimensions nSpec * nChan		*/
		/* Each provides a mapping from channel number to	*/
		/* position sorted by wavelength.  fMap and rMap are	*/
		/* conjugate.						*/
		/*							*/
		/* For example: to fill count[][] with photon counts	*/
		/* such that its channels are sorted by wavelength,	*/
		/* you'd use the following loops:			*/
		/*							*/
		/* for(iSpec = 0; iSpec < nSpec; iSpec++)		*/
		/*     for(iChan = 0; iChan < nChan; iChan++)		*/
		/*         count[iSpec][fMap[iChan]] =			*/
		/*                 photon_counts[iSpec][iChan];		*/
		/*							*/
		/* The reverse mapping allows the same assignment	*/
		/* to take place.					*/
		/*							*/
		/* for(iSpec = 0; iSpec < nSpec; iSpec++)		*/
		/*     for(iChan = 0; iChan < nChan; iChan++)		*/
		/*         count[iSpec][iChan] = 			*/
		/*                 photon_counts[iSpec][rMap[iChan]];	*/
		/* **************************************************** */
		int	**fMap;
		int	**rMap;
};

#endif
