/* datacon.h - include file for DATAcon structures */

#ifndef _DATACON_H
#define _DATACON_H

/* 
   Packet type enumeration should really be a part of this file,
   but it is auto-generated and easiest to keep in a separate file.
   The packet body definitions would overwhelm this file and so are also
   a separate file.
*/
#include "packettype.h"
#include "packetdefs.h"

typedef struct
{
  int32 dchType;                   /* Packet type */
  uint32 dchLength;                /* Length of entire packet */
  uint32 dchTime;                  /* Timestamp in milliseconds */
  uint32 dchDay;		   /* Day number */
  uint32 dchInstance[3];           /* Instance vector */
  uint32 dchHeaderCRC;             /* CRC of header */
  uint32 dchBodyCRC;               /* CRC of rest */
  uint32 dchPad[7];                /* Pad to 64 bytes */
} DATAconHeader;

typedef struct MetroHeader 
{
  uint8 uType;           /* Metrology packet type */
  uint8 uPlate;          /* HDS plate number */
  uint8 uSIDcon;         /* Sidcon number */
  uint8 uNumChannels;    /* Number of channels per packet */
  uint8 uNumClusters;    /* Number of optical anchor clusters */
  uint8 uNumLaserMax;    /* Maximum number of lasers per cluster */
  uint8 uNumBits;        /* Number of bits per datum */
  uint8 uPad;            /* 8-bit pad */
  uint16 uPeriod;        /* Sample rate in milliseconds */
  uint16 uNumSamples;    /* Number of samples per subpacket */
} MetroHeader;

typedef struct MetroSubHeader {
  uint8 uCluster;
  uint8 uChannel;
  uint8 uBank;
  uint8 uDetector;
} MetroSubHeader;

/* Function prototypes */
/* Note: these functions are not part of CONSTRICTOR */

void 
DataConInit(char azOutFileName[], int *piStatus);

void 
DataConTerminate(int *piStatus);

unsigned int 
GenCRC32(unsigned int iOldCRC, unsigned int Words[], int iNWords);

void 
DataConWritePacket(DATAconHeader *pPktHdr, void *PktBody, int *piStatus);

void 
MakeDefaultHeader(DATAconHeader *pPktHdr, uint32 Type, 
		       uint32 iBodyLength, int *piStatus);

#endif /* _DATACON_H */
