/* ******************************************************************** */
/* npoi_config.h							*/
/* 2002-08-12  Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _NPOI_CONFIG_H
#define _NPOI_CONFIG_H

#include <stdio.h>
#include "defs.h"

#define FORMAT_VERSION	3

#define DEFSTRLEN	80
#define MAX_IDSTR	16

#define FILENAME_TIMESTAMP_LEN		6
#define FILENAME_TIMESTAMP_DIVISOR	100

/* ******************************************************************** */
/* ANY CHANGES TO THIS STRUCTURE MUST BE FOLLOWED IN MOST FUNCTIONS IN	*/
/* npoi_config.C							*/
/* ******************************************************************** */

/* ******************************************************************** */
/* Arrays to sit inside config data					*/
/* ******************************************************************** */
typedef struct {
	double	wavelength;		/* in METERS	*/
	double	wavelengthErr;		/* RMS error	*/
	double	chanWidth;		/* in METERS	*/
	double	chanWidthErr;		/* RMS error	*/
} SPEC_CHAN;

typedef struct {
	uint32	bcOutputID;		/* Output port			*/
	uint32	nFringeFreq;		/* Number of fringe freqs on	*/
					/* this output (1 for now)	*/
	int32	(*inputPair)[2];	/* Indices (0->num_sid-1) into	*/
					/* the input_beam pointer	*/
					/* defining which pairs of	*/
					/* input beams combine to give	*/
					/* this output fringe.  Set	*/
					/* negative for a dummy freq.	*/
					/* Dimension: nBas		*/
	uint32	*fringeMod;		/* Baseline modulation, 1 to 8	*/
					/* Dimension: nBas		*/
	uint32	apdArrayID;		/* ID of the spectrometer APD	*/
					/* array			*/
	uint32	nSpecChan;		/* Number of spectral channels	*/
       					/* on this output		*/
	SPEC_CHAN	*specChan;	/* Spectral channels		*/
					/* Dimension: nChan		*/
} OUTPUT_BEAM;

typedef struct {
	char	stationID[MAX_IDSTR];	/* Pier ID, e.g. "N01"		*/
	double	stationCoord[4];	/* Baseline model coordinates	*/
					/* where X=east, Y=north, Z=up	*/
					/* with a delay constant as the	*/
					/* fourth term, all in METERS	*/
	uint32	sidID; 			/* ID returned by SIDcon rack	*/

	uint32	fdlTankID;		/* Tanks ID (from 1 to 6)	*/
	double	stroke;			/* in METERS			*/
	uint32	quadCellID;
	uint32	bcInputID;		/* Input port			*/
} INPUT_BEAM;

class NPOI_CONFIG {
	public:
	NPOI_CONFIG(uint32, uint32, uint32, uint32);
	NPOI_CONFIG(uint32, uint32, uint32, uint32, uint32, uint32, uint32);
	NPOI_CONFIG(FILE *);
	NPOI_CONFIG(const NPOI_CONFIG &);
	~NPOI_CONFIG();

	void save(FILE *);
	void load(FILE *);

	void swap();

	char *buildFilename(char *, char*);

	char		formatVersion;	/* Structure version number	*/
	char		native;		/* 0=network order, 1=native	*/

	uint32		nFrame;		/* Number of frames		*/
	uint32		nSid;		/* Number of siderostats	*/
	uint32		nBas;		/* Number of baselines		*/
	uint32		nFdl;		/* Number of delay lines	*/
	uint32		nTriple;	/* Number of possible triples	*/
	uint32		nSpec;		/* Number of spectrometers	*/
	uint32		nChan;		/* Number of channels		*/
	uint32		nBin;		/* Number of sample bins	*/

	/* ************************************************************ */
	char		starID[DEFSTRLEN];	/* catalog name		*/
	char		starName[DEFSTRLEN];	/* user-specified name	*/
	uint32		date;	/* date at beginning of night, may be	*/
				/* one day off from actual observation	*/
				/* date if observation occurs past	*/
				/* midnight				*/

	uint8		fringeFlag;

	double		catalogRA;
	double		catalogDec;
	double		apparentRA;
	double		apparentDec;

	/* ************************************************************ */
	uint32		firstTS;	/* First and last timestamps,	*/
	uint32		lastTS;		/* as found in the fringe_time	*/
					/* fields of the records.	*/
					/* These are simply duplicates	*/
					/* of those values, useful only	*/
					/* for categorizing this scan.	*/

	uint32		scanID;		/* Unique for this scan		*/


	/* ************************************************************ */
	/* Servo params							*/
	/* ************************************************************ */
	double	proGainX;		/* Proportional			*/
	double	proGainY;
	double	intGainX;		/* Integral			*/
	double	intGainY;
	double	derGainX;		/* Derivative			*/
	double	derGainY;

	double	filterGainX;
	double	filterGainY;
	double	lowPassA;

	double	sidGainX;
	double	sidGainY;
	/* ************************************************************ */

	double	latitude;		/* Latitude in DEGREES		*/
	double	longitude;		/* Longitude DEGREES, east +ve	*/
	double	altitude;		/* Altitude in METERS		*/
	double	earthRadius;		/* Earth's radius in METERS	*/
	double	J2;			/* Earth's flattening		*/
	double	tdtMinusUTC;		/* SECONDS, right now is 60.184	*/
	double	ut1MinusUTC;		/* SECONDS, varies from day to	*/
					/* day.  Zero if unknown	*/
	double	instrCohInt;		/* Fringe sample time in MSEC	*/
					/* Er, "milliseconds"		*/
	uint32	beamCombinerID;		/* Which beam combiner		*/
	uint32	nPlate;

	uint32	darkTime;		/* Timestamp on DARK packet	*/
	uint32	darkNumIntegrations;
	int32	**darkCounts;		/* Dimensions:			*/
					/* nSpec * nChan		*/

	INPUT_BEAM	*inputBeams;	/* Dimension: nSid		*/
	OUTPUT_BEAM	*outputBeams;	/* Dimension: nSpec		*/

	private:
	void init(uint32, uint32, uint32, uint32);
};

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif
