/* ******************************************************************** */
/* npoi_container.h							*/
/* 2002-08-05  Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _NPOI_CONTAINER_H
#define _NPOI_CONTAINER_H

#include <stdio.h>
#include "npoi_config.h"
#include "npoi_frame.h"

class NPOI_CONTAINER {
	public:
	NPOI_CONTAINER();
	NPOI_CONTAINER(FILE *);
	NPOI_CONTAINER(char *);
	NPOI_CONTAINER(NPOI_CONFIG *);
	NPOI_CONTAINER(NPOI_CONFIG *, NPOI_FRAME *);
	~NPOI_CONTAINER();

	void save(FILE *);
	void save(char *);
	void load(FILE *);
	void load(char *);
	void sortFrames();
	void updateTS();

	NPOI_CONFIG	*config;		/* Dimensions: 1		*/
	NPOI_FRAME	*frames;		/* Dimensions: nFrame		*/
};

int sortFrameFunc(const void *, const void *);

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif
