/* ******************************************************************** */
/* npoi_frame.h								*/
/* 2002-08-12  Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _NPOI_FRAME_H
#define _NPOI_FRAME_H

#include <stdio.h>
#include "npoi_config.h"
#include "defs.h"

/* ******************************************************************** */
/* ANY CHANGES TO THIS STRUCTURE MUST BE FOLLOWED IN THESE FUNCTIONS:	*/
/* npoi_frame.c:destroy_npoi_frame					*/
/* npoi_import.c:process_packet						*/
/* npoi_container.c:expand_npoi_container				*/
/* npoi_io.c:npoi_load							*/
/* npoi_io.c:npoi_save							*/
/* npoi_order.c:swap_byte_order						*/
/* ******************************************************************** */

/* ******************************************************************** */
/* Arrays to sit inside record data					*/
/* ******************************************************************** */
typedef struct {
	int16	val;		/* Net delay in 0.01 microns		*/
	int16	err;		/* RMS error in 0.01 microns		*/
} FRINGE_CON_DELAY_ESTIMATE;

typedef struct {
	uint32	laserLo;	/* lo 32 bits of laser counter		*/
	uint32	laserHi;	/* hi 32 bits of laser counter		*/
	int32	jitter;		/* unfiltered current jitter		*/

	double	adfLaser;	/* actual laser value, calc'd from	*/
				/* lo and hi bits.			*/
} FDL_POSITION;

typedef struct {
	uint16	quadA;		/* Lower right				*/
	uint16	quadB;		/* Lower left				*/
	uint16	quadC;		/* Upper left				*/
	uint16	quadD;		/* Upper right				*/
	int16	deltaX;		/* X Piezo signal offset		*/
	int16	deltaY;		/* Y Piezo signal offset		*/
} NAT_COUNTS;

/* ******************************************************************** */
/* Each npoi_frame accounts for roughly 2ms of time.			*/
/* ******************************************************************** */
class NPOI_FRAME {
	public:
		NPOI_FRAME();
		NPOI_FRAME(uint32, uint32, uint32, uint32, uint32);
		NPOI_FRAME(NPOI_CONFIG *);
		NPOI_FRAME(const NPOI_FRAME &);
		~NPOI_FRAME();

		void	save(FILE *);
		void	load(FILE *);

		void	swap();

		double	calculateADFLaser(uint32, uint32);
		void	calculateADFLasers();

		bool operator < (const NPOI_FRAME &) const;

		char	*buildTimeStamp();
		void	unlink();
		void	deleteArrays();

		char	formatVersion;	/* Structure version number	*/
		char	native;		/* 0=network order, 1=native	*/

		uint32	fringeTime;	/* UT time in 100us units	*/
		uint32	fdlTime;	/* Same, only for FDLs		*/
		uint32	natTime;	/* Same, only for NATs		*/
		uint8	***photonCounts;
					/* Raw counts.  Dimensions:	*/
					/* nSpec, nChan, nBin		*/

		FRINGE_CON_DELAY_ESTIMATE *fringeConDelayEstimate;
					/* Dimension: nSpec		*/
	
		FDL_POSITION	*fdlPosition;	/* Dimension: nFdl	*/
		NAT_COUNTS	*natCounts;	/* Dimension: nSid	*/

	private:
		uint32	nSid;		/* Stats vital to the sizes of	*/
		uint32	nFdl;		/* the elements in NPOI_FRAME	*/
		uint32	nSpec;		/* These are exact copies of	*/
		uint32	nChan;		/* the vals in NPOI_CONFIG and	*/
		uint32	nBin;		/* are kept here to allow	*/
					/* NPOI_FRAME to stand on its	*/
					/* own				*/

					/* They are also ALWAYS in	*/
					/* native format and don't EVER	*/
					/* get stashed on disk.		*/
};

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif
