/* ******************************************************************** */
/* npoi_import.h							*/
/* 2002-08-06  Dan Driscoll						*/
/* ******************************************************************** */

#ifndef _NPOI_IMPORT_H
#define _NPOI_IMPORT_H

#include "npoi_container.h"
#include "packettype.h"
#include "packetdefs.h"
#include "datacon.h"
#include <sys/types.h>

#define FS_FRINGE	".fringeData"
#define FS_ALIGN	".alignData"

typedef struct {
	uint32	time;
	uint32	seek;
	char	fd;
} alignStruct;

void	importFringe(char *, char *);
void	searchDirectoryForData(char *, char *, char ***,
		FILE ***, int *);
void	processPacket(DATAconHeader *, void *, NPOI_CONTAINER *,
		NPOI_CONFIG *, int *);
void	importAlign(char *, char *);
void	processAlign(DATAconHeader *, void *, alignStruct **,
		int *, char, uint32);

int	sortAlignFunc(const void *, const void *);
void	packDataFiles(char **, int, alignStruct *, int, FILE **);
int	findFirstInstance(alignStruct *, int, uint32);
void	countFramesInFiles(FILE **, int ***, int **, int);

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#endif
