/* ******************************************************************** */
/* npoi_import_support.C						*/
/* 2002-08-06  Dan Driscoll						*/
/* ******************************************************************** */

#include <assert.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "packetdefs.h"
#include "npoi_io.h"
#include "npoi_import_support.h"
#include "npoi_container.h"
#include "npoi_config.h"
#include "npoi_frame.h"
#include "npoi_order.h"


/* ******************************************************************** */
/* saveStar								*/
/* ******************************************************************** */
void saveStar(NPOI_CONTAINER *data, char *outdir) {
	char	*filename;

	if(!data) { return; }

	data->sortFrames();
	data->updateTS();

	filename = data->config->buildFilename(outdir, ".gz");

	data->save(filename);

	delete [] filename;
}


/* ******************************************************************** */
/** initConfig
   Allocate and return an NPOI_CONFIG with all the defaults set.	*/
/* ******************************************************************** */
NPOI_CONFIG *initConfig() {
	NPOI_CONFIG	*config;

	config = new NPOI_CONFIG(
			VAR_NUM_SID,
			VAR_NUM_BAS,
			VAR_NUM_FDL,
			VAR_NUM_TRPLE,
			VAR_NUM_SPEC,
			VAR_NUM_CHAN,
			NUM_BIN);

	/* ************************************************************ */
	/** Starting out with 0 frames, not 500!			*/
	/* ************************************************************ */
	config->nFrame = 0;

	assert(config->native);

	return config;
}
