/* ******************************************************************** */
/* npoi_order.C								*/
/* 2002-08-05  Dan Driscoll						*/
/* ******************************************************************** */

#include <netinet/in.h>
#include "npoi_order.h"

extern "C" {
#include "swap.h"
}

/* ******************************************************************** */
void swapd(double *data, char s) {
	*data = swapdouble(*data);
}

void swapf(float *data, char s) {
	unsigned int	*dtmp;

	dtmp = (unsigned int *)data;

	*data = s ? htonl(*dtmp) : ntohl(*dtmp);
}

/* ******************************************************************** */
void swapl(unsigned long int *data, char s) {
	*data = s ? htonl(*data) : ntohl(*data);
}

void swapl(long int *data, char s) {
	*data = s ? htonl(*data) : ntohl(*data);
}

/* ******************************************************************** */
void swaps(unsigned short int *data, char s) {
	*data = s ? htons(*data) : ntohs(*data);
}

void swaps(short int *data, char s) {
	*data = s ? htons(*data) : ntohs(*data);
}

/* ******************************************************************** */
double hostd(double data, char s) {
	return s ? data : swapdouble(data);
}

float hostf(float data, char s) {
	return s ? data : swapfloat(data);
}

/* ******************************************************************** */
unsigned long int hostl(unsigned long int data, char s) {
	return s ? data : ntohl(data);
}

long int hostl(long int data, char s) {
	return s ? data : ntohl(data);
}

/* ******************************************************************** */
unsigned short int hosts(unsigned short int data, char s) {
	return s ? data : ntohs(data);
}

short int hosts(short int data, char s) {
	return s ? data : ntohs(data);
}
