/* ******************************************************************** */
/* npoi_reader.C							*/
/* 2002-08-06  Dan Driscoll						*/
/* ******************************************************************** */

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include "npoi_import.h"

int main(int argc, char **argv) {
	char		indir[BUFSIZ];
	char		outdir[BUFSIZ];
	char		c;
	int		idx;
	char		help_flag = 0;

	struct option	opts[] = {
	{ "indir",	1, 0, 'i' },
	{ "outdir",	1, 0, 'o' },
	{ "help",	0, 0, 'h' },
	{ NULL,		0, 0, 0   }};

	indir[0] = 0;
	outdir[0] = 0;

	while((c = getopt_long(argc, argv, "i:o:h", opts, &idx)) != -1) {
		switch(c) {
			case 'i' :
				strncpy(indir, optarg, BUFSIZ);
				break;
			case 'o' :
				strncpy(outdir, optarg, BUFSIZ);
				break;
			case 'h' :
			default  :
				help_flag = 1;
				break;
		}
	}

	if(!*indir && !*outdir) {
		help_flag = 1;
	}

	if(help_flag == 1) {
		fprintf(stderr, "Usage: %s -i indir -o outdir [-h]\n", argv[0]);
		fprintf(stderr, " -i <indir>	Location of input files\n");
		fprintf(stderr, " -o <outdir>	Location of output files\n");
		fprintf(stderr, " -h		Help\n");

		exit(1);
	}

	importFringe(indir, outdir);

	return 0;
}
