#include <stdio.h>
#include "pktprint.h"

void print_packet(DATAconHeader CurrentHeader, int go) {
	int iType, iHour, iMin;
	unsigned long iByteTotal=0;
	unsigned long iDay, jDay;
	float fTime, fSec;

	if(!go) {
		return;
	}

      iType = CurrentHeader.dchType;
      jDay = CurrentHeader.dchDay;
      if (jDay == 0) jDay = iDay;
      fTime=(float)(CurrentHeader.dchTime+(jDay-iDay)*86400000)/3600000;
      fTime=(float)(CurrentHeader.dchTime)/3600000;
      iHour=(int)fTime;
      iMin=(int)((fTime-iHour)*60);
      fSec=(fTime-iHour-iMin/60.0)*3600;
      printf("%8lx %6ld %6ld %6ld %2.2dh%2.2dm%4.1fs",CurrentHeader.dchType,
	     CurrentHeader.dchLength - sizeof(DATAconHeader),
	     CurrentHeader.dchTime,CurrentHeader.dchDay,iHour,iMin,fSec);
      switch(CurrentHeader.dchType){
        case pktFILE_HEADER:
                printf(" FILE_HEADER\n");
		break;
        case pktPACKET_SYMBOL_TABLE:
                printf(" PACKET_SYMBOL_TABLE\n");
		break;
        case pktPACKET_DIRECTORY:
                printf(" PACKET_DIRECTORY\n");
		break;
        case pktPAD:
                printf(" PAD\n");
		break;
        case pktEND_OF_DISK:
                printf(" END_OF_DISK\n");
		break;
        case pktEND_OF_SESSION:
                printf(" END_OF_SESSION\n");
		break;
        case pktSYS_CONFIG:
                printf(" SYS_CONFIG\n");
		break;
        case pktSYS_LOG:
                printf(" SYS_LOG\n");
		break;
        case pktSCAN_START_VERSION_1:
                printf(" SCAN_START\n");
		break;
        case pktSCAN_START_VERSION_2:
                printf(" SCAN_START\n");
		break;
        case pktSTAR_ACQUIRED:
                printf(" STAR_ACQUIRED\n");
		break;
        case pktSCAN_END:
                printf(" SCAN_END\n");
		break;
        case pktSCAN_OPERATOR_COMMENT:
                printf(" SCAN_OPERATOR_COMMENT\n");
		break;
        case pktFRINGE_DATA_VERSION_1:
                printf(" FRINGE_DATA\n");
		break;
        case pktFRINGE_DATA_VERSION_2:
                printf(" FRINGE_DATA\n");
		break;
        case pktFRINGE_BG:
                printf(" FRINGE_BG\n");
		break;
        case pktFRINGE_DARK:
                printf(" FRINGE_DARK\n");
		break;
        case pktFRINGECON_SERVO_PARAMS:
                printf(" FRINGECON_SERVO_PARAMS\n");
		break;
        case pktNAT_COUNTS:
                printf(" NAT_COUNTS\n");
		break;
        case pktNAT_PIEZO_SIGNAL:
                printf(" NAT_PIEZO_SIGNAL\n");
		break;
        case pktNAT_BG:
                printf(" NAT_BG\n");
		break;
        case pktNAT_DARK:
                printf(" NAT_DARK\n");
		break;
        case pktNAT_SERVO_PARAMS:
                printf(" NAT_SERVO_PARAMS\n");
		break;
        case pktFDL_POSITION:
                printf(" FDL_POSITION\n");
		break;
        case pktFDL_JITTER:
                printf(" FDL_JITTER\n");
		break;
        case pktFDL_STATUS:
                printf(" FDL_STATUS\n");
		break;
        case pktMETRO_DATA:
		printf(" METRO_DATA\n");
		break;
        case pktWASA_IMAGE:
                printf(" WASA_IMAGE\n");
		break;
        case pktSID_MOTOR_COUNTS:
                printf(" SID_MOTOR_COUNTS\n");
		break;
        case pktSID_MODEL:
                printf(" SID_MODEL\n");
		break;
        case pktSYNC:
                printf(" SYNC\n");
		break;
	case pktMETRO_CONFIG:
		printf(" METRO_CONFIG\n");
		break;
	default:
		printf("UNKNOWN\n");
		break;
      }
      iByteTotal+=CurrentHeader.dchLength;
}
