/* defs.h - defines that should be in nearly any prog you can think of */

#ifndef _MY_DEFS
#define _MY_DEFS

#undef PI
#define PI 3.14159265358979323846
#define TWOPI 6.28318530717958647692
#define RAD2DEG(x) ( (x) * (180.0 / PI) )
#define DEG2RAD(x) ( (x) * (PI / 180.0) )

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

/* Define fixed-width integers to give machine-independence where needed.
   The definitions below hold for a typical, i.e. say Pentium PC, 32 bit
   architecture. But if we go to 64 bit, int might be 8 byte, so int32 will
   no longer be int, but a different type to be specified in the compiler
   for that machine.  */

#define uint32 unsigned int
#define uint16 unsigned short
#define uint8  unsigned char
#define int32  int
#define int16  short

#define MIN(a,b) ( a > b ? b : a )
#define MAX(a,b) ( a < b ? b : a )
#define STREQ(a,b) ( strcmp((a),(b)) == 0 )
#define STRNEQ(a,b,n) ( strncmp((a),(b),(n)) == 0 )

#define MAXSTR  500             /* For sizing strings -- DON'T use BUFSIZE! */

/* Complex numbers - this definition should be the same as f2c's. Strange
   things may happen if not... */

#ifndef F2C_INCLUDE
typedef struct { float r, i; } complex;
#endif

#endif /* _MY_DEFS */
