/* sys_config.h - C structure definition for SYS_CONFIG packet */

#define MAX_IDSTR 16            	/* Length of ID strings */

typedef struct {

  double Latitude;                         /* Unit = DEGREES */
  double Longitude;                        /* EAST +ve, Unit = DEGREES */
  double Altitude;                         /* Unit = METERS */
  double EarthRadius;			   /* Earth's radius in METERS */
  double J2;				   /* Earth's flattening */
  double TDTminusUTC;                      /* Unit = SECONDS, right now
					      it is 60.184 */
  double UT1minusUTC;                      /* Unit = SECONDS. Varies from
                                              day to day, set it to zero 
                                              if unknown */
  double InstrCohInt;                      /* Fringe sample time UNIT = MSEC */
  int NumBin;                              /* Number of bins per fringe in
					      the binner card */
  int BeamCombinerID;                      /* Which beam combiner */
  int NumPlate;

  struct {
    int NumSid;                            	/* # of siderostats in use */
    char StationID[VAR_NUM_SID][MAX_IDSTR];    	/* Pier ID, e.g. "N01" */
    double StationCoord[VAR_NUM_SID][4] ;      	/* Baseline model coordinates
					      	   in local coords, X = east,
					           Y = north, Z = up, plus delay 
					           constant. Units = METERS */
    int SiderostatID[VAR_NUM_SID];             	/* ID number returned by SIDcon
					           rack */
    int FDLTankID[VAR_NUM_SID];                	/* Tanks 1-6 */
    double Stroke[VAR_NUM_SID];			/* Stroke in m for each delay line */
    int QuadCellID[VAR_NUM_SID];               	/* Quad cell looking at same input
					           beam */ 
    int BCInputID[VAR_NUM_SID];                	/* Input port of the beam 
					           combiner */
  } InputBeam;

  struct {
    int NumOutBeam;                          /* Total number of spectrographs */
    int BCOutputID[VAR_NUM_SPEC];            /* Output port # */
    int NumFringeFreq[VAR_NUM_SPEC];         /* Number of fringe frequencies on
					      this output (1 for now) */
    int InputPair[VAR_NUM_SPEC][VAR_NUM_BAS][2];
                                           /* Indexes (0..iNumSid-1) into the
                                              InputBeam structure defining
					      which pair of input beams combine
					      to give this output fringe. Set
					      negative for a dummy frequency */
    int FringeMod[VAR_NUM_SPEC][VAR_NUM_BAS];/* Baseline Modulation, from 1 to 8 */
    int NumSpecChan[VAR_NUM_SPEC];           /* Number of spectral channels on
					        this output */
    int APDArrayID[VAR_NUM_SPEC];            /* ID of the spectrometer APD
					        array */
    double Wavelength[VAR_NUM_SPEC][VAR_NUM_CHAN];
                                             /* Channel wavelength in METERS */
    double WavelengthErr[VAR_NUM_SPEC][VAR_NUM_CHAN] ;
                                             /* Rms error in above */
    double ChanWidth[VAR_NUM_SPEC][VAR_NUM_CHAN] ;
                                             /* Channel FWHM in METERS */
    double ChanWidthErr[VAR_NUM_SPEC][VAR_NUM_CHAN] ;
                                             /* Rms error in above */

  } OutputBeam;

} SYS_CONFIG_C_STRUCT;

extern SYS_CONFIG_C_STRUCT SysConfig;
