/***********************************************************************
 * FractRadius: 
 * Calculates the radius as a function of the co-latitude for a Roche
 * Spheroid.  The variables are small Omega and sin theta, both squared.
 * 
 * Note: This gives the radius in units of the Polar Breakup Radius
 * which is less than 1, even when w=0.
 *
 * Note: Following Hardorp and Scholz, have suppressed the shrinkage of
 * the polar axis with omega.  It's =1 now.  For good.
************************************************************************/
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "roche.h"

float FractRadius (float w2, float s2) {

  float dy, dydx;
  float Xo = 1.; // 1.0 le Xo le 1.5!
  //float scalepole = 0.1087 ; // Approximately keeps the model at const lum.
  float scalepole = 0.; // No it didn't!  This is much better!!
  float B = (1.-scalepole)/(1.-scalepole*w2);
  float A = 4.*w2*s2/27.;
  float dx = Xo;
  int ic=0;

  //printf("FR: A=%1.6g B=%1.6g\n", A, B);
  while (fabs(dx/Xo) > 1.e-5 && ic <= 20) {
    dy = (1./Xo+A*Xo*Xo-B);
    dydx = 1./Xo/Xo-2.*A*Xo;
    dx = dy/dydx;
    Xo += dx;
    //printf("    ic=%1i dy=%1.6g dydx=%1.6g dx=%1.6g Xo=\n",
    //ic, dy, dydx, dx, Xo);
    ic++;
  }
  if (ic > 20)printf("FR: ic > 20 without converging! Continuing.\n");
  return Xo;
}
