/* Modified for use in OYSTER by C.A. Hummel */

/***********************************************************************
 * InitRoche: Brings in model parameters, sets up the wavelengths, and
 * loads the (model atmosphere) limbdarkening grid file.
 **********************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "rochechi2.h"
/* #include "roche.h" */

int InitRoche1(Roche * R, LimbDark * LD, char * name, float *pfRocheParms, 
	      int *piN, float *pfLam, int * j1Wave, int * j2Wave,
	      int *piLDinit, int *piWavesMax, int *piTeffMax, int *piLogGMax,
	      int *paiLogG,
	      float *pafLD, float *pafLogG, float *pafWaves, float *pafTeff) {

  int i,j,k;

  /* Set the wavelength indices */
  *j1Wave=0;
  *j2Wave=piN[0];
  
  /* Fill in the Roche model paramaters */
  R->fwOmega = pfRocheParms[0];
  R->fRNot = pfRocheParms[1];
  R->fTeffpB = pfRocheParms[2];
  R->fMass = pfRocheParms[3];
  R->fIncl = pfRocheParms[4];
  R->fPA = pfRocheParms[5];
  R->fAngDiam_pB = pfRocheParms[6];
  
  if (piLDinit[0] != 0) {

    /* Initialize LD */
    strcpy(LD->sInstrument,"NPOI"); // Limb darkening law
    strcpy(LD->sWaveset,"Reg"); // Use regular set, here supplied by OYSTER
    strcpy(LD->sLDLaw,"Lin"); // Limb darkening law
    if (piLDinit[0] == 2) strcpy(LD->sLDLaw,"Log");
    if (piLDinit[0] == 3) strcpy(LD->sLDLaw,"Sqrt");

    /* Store Limb Darkening data */

    LD->indexWaveMax=piWavesMax[0];
    LD->iTeffMax = piTeffMax[0];
    for (j = 0; j < piWavesMax[0]; j++) LD->afWaves[j] = pafWaves[j];
    for (k = 0; k < piLogGMax[0]; k++) LD->afLogG[k] = pafLogG[k];
    for (i = 0; i < piTeffMax[0]; i++) {
      LD->aiLogG[i] = paiLogG[i];
      LD->afTeff[i] = pafTeff[i];
      for (j = 0; j < piWavesMax[0]; j++) {
	for (k = 0; k < piLogGMax[0]; k++) {
	  LD->afLD[0][i][k][j] = pafLD[0+3*(i+piTeffMax[0]*(k+piLogGMax[0]*j))];
	  LD->afLD[1][i][k][j] = pafLD[1+3*(i+piTeffMax[0]*(k+piLogGMax[0]*j))];
	  LD->afLD[2][i][k][j] = pafLD[2+3*(i+piTeffMax[0]*(k+piLogGMax[0]*j))];
	}
      }
    }
  }
 
  return EXIT_SUCCESS;
}
