/***********************************************************************
 * ReadInclinations: Brings in the polar inclinations and angular
 * rotation rates (in units of breakup).  If the "inclinations" file is
 * not found it asks for values.
 *
 * Updated for Ver 1.4 to also supply the (polar Breakup) angular
 * diameter in mas
 **********************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "roche.h"

int ReadInclinations(Roche * R, int iInclmax, float * Incl, float * W,
	      float * DpBmas, int * iIncl) {

  int i; char line[81];
  FILE *fp;

  /* See if there's an file specifying the inclinations */
  if ((fp = fopen("inclinations", "r")) != NULL) {
    if (fgets(line, 80, fp) == NULL) {
      printf("Inclinations File Empty!  Bailing out.");
      return EXIT_FAILURE;
    }
    strtok(line," ");
    *iIncl = atoi(strtok(NULL," \n"));
    if (*iIncl > iInclmax) {
      printf("Number of Inclinations constrained to %1i", iInclmax); 
      printf(", max.  Resetting index to that.\n");
      *iIncl = iInclmax;
    }
    for (i = 0; i < *iIncl; i++) {
      if (fgets(line, 80, fp) == NULL) {
	printf("Line %1i in Inclinations File Empty!  Bailing out.", i);
	return EXIT_FAILURE;
      }
      strtok(line," ");
      Incl[i] = atof(strtok(NULL," "));
      strtok(NULL," ");
      W[i] = atof(strtok(NULL," "));
      strtok(NULL," ");
      DpBmas[i] = atof(strtok(NULL," "));

      Incl[i] *= (float)RADDEG;
    }
  }
  else {
    printf("No inclination file, will ask for them:\n");
    printf("How many inclinations (<=%1i)? ", iInclmax);
    scanf("%1i", iIncl);
    if (*iIncl > iInclmax) {
      printf("Too many!\n");
      return EXIT_FAILURE;
    }
    for (i = 0; i < *iIncl; i++) {
      printf("i=%1i: Incl (deg): ",i);
      scanf("%f", &Incl[i]);
      //printf("Incl: %f\n",Incl[i]);
      printf("Fractional angular velocity: ");
      scanf("%f",&W[i]);
      printf("Polar Ang Diam at Breakup(mas): ");
      scanf("%f",&DpBmas[i]);
      getchar(); // clear CRLF!
      printf("Incl=%g W=%g DpB=%g\n",Incl[i],W[i],DpBmas[i]);
      Incl[i] *= (float)RADDEG;
    }
  }

  printf("\nInclination(s):\n");
  for (i = 0; i < *iIncl; i++) {
    printf("  i=%1i Incl=%1.6g W=%1.6g DpB=%1.6g\n", i, 
	   Incl[i]*(float)DEGRAD, W[i], DpBmas[i]);
  }

  return EXIT_SUCCESS;
}
