/***********************************************************************
 * ReadLimbDark: Loads the limb darkening grid file.  The parts of the
 * array that are loaded and the values of the various parameters are
 * determined on the fly.
 *
 * Fixed bug found by Christian in returned index of number of Teff's
 * 28/02/04.
 **********************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "roche.h"

int ReadLimbDark(LimbDark * LD) {

  FILE *fld;
  char sLDFile[50], line[81];
  int i, iTeff, ilogG, WaveMax;
  float Teff_now, Teff, logG;

  /* Construct the file name */
  strcpy(sLDFile,"LimbDarkening/");
  strcat(sLDFile,LD->sInstrument);
  strcat(sLDFile,"_");
  strcat(sLDFile,LD->sWaveset);
  strcat(sLDFile,"_");
  strcat(sLDFile,LD->sLDLaw);
  strcat(sLDFile,".dat");
  //printf("sLDFile: %s\n", sLDFile);

  /* Open file and get it started */
  if ((fld = fopen(sLDFile, "r")) != NULL) {
    if (fgets(line, 81, fld) == NULL) {
      /* Big problem */
      printf("Limb Darkening File empty! Bailing out.");
      return EXIT_FAILURE;
    }
    else {
      printf("Limb Darkening File: %s\n     %s",sLDFile,line);
    }

    /* First time in */
    Teff_now=0.;
    iTeff=-1;
    for (;;) {
      if (fgets(line, 81, fld) == NULL) {
	/* EOF, close it up */
	//printf("End of LD file, returning...\n");
	return EXIT_SUCCESS;
      }
      if (strstr(line,"Teff ") != NULL) {
	sscanf(line,"Teff %5f  glog  %5f  waves%3i",&Teff,&logG,&WaveMax);
	if (iTeff == -1) LD->indexWaveMax=WaveMax;
	if (Teff != Teff_now) {
	  iTeff++;
	  LD->iTeffMax = iTeff+1; // count number of Teffs, fixes bug
	  LD->afTeff[iTeff]=Teff;
	  Teff_now=Teff;
	  LD->aiLogG[iTeff] = 0;
	  //if (iTeff == 1) return EXIT_FAILURE;
	}
	ilogG = (int)((5.0 - logG + 0.49)*2.);
	if (LD->aiLogG[iTeff] < ilogG+1) LD->aiLogG[iTeff] = ilogG+1;
	LD->afLogG[ilogG]=logG;
      }

      /* Every thing else except the column heading line is data */
      else if (strstr(line,"Idx") == NULL) {

	if (!strcmp(LD->sWaveset,"Mon")){
	  /* One or two coefficients? */
	  /* One */
	  if (!strcmp(LD->sLDLaw,"Lin")) {
	    sscanf(line,"%3i",&i);
	    sscanf(line,"%*3c%7f%7f%7f",&LD->afWaves[i-1],
		   &LD->afLD[0][iTeff][ilogG][i-1],
		   &LD->afLD[2][iTeff][ilogG][i-1]);
	  }
	  /* Two */
	  else {
	    sscanf(line,"%3i",&i);
	    sscanf(line, "%*3c%7f%7f%8f%7f",&LD->afWaves[i-1],
		   &LD->afLD[0][iTeff][ilogG][i-1],
		   &LD->afLD[1][iTeff][ilogG][i-1],
		   &LD->afLD[2][iTeff][ilogG][i-1]);
	  }
	}

	/* Not monochromatic */
	else {
	  /* One or two coefficients? */
	  /* One */
	  if (!strcmp(LD->sLDLaw,"Lin")) {
	    sscanf(line,"%3i",&i);
	    sscanf(line,"%*3c%6f%*6c%6f%6f",&LD->afWaves[i-1],
		   &LD->afLD[0][iTeff][ilogG][i-1],
		   &LD->afLD[2][iTeff][ilogG][i-1]);
	  }
	  /* Two */
	  else {
	    sscanf(line,"%3i",&i);
	    sscanf(line, "%*3c%6f%*6c%6f%7f%6f",&LD->afWaves[i-1],
		   &LD->afLD[0][iTeff][ilogG][i-1],
		   &LD->afLD[1][iTeff][ilogG][i-1],
		   &LD->afLD[2][iTeff][ilogG][i-1]);
	  }
	}
      }
    }
  }
  else {
    printf("Limb Darkening File Missing!  Bailing out.");
    return EXIT_FAILURE;
  }
}

