/***********************************************************************
 * ReadModel: Brings in the physical parameters of the model, the
 * object's name, the default wavelength set and the limbdarkening law
 * to use.  The last two become part of the file name for reading in the
 * model atmosphere grid.
 **********************************************************************/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "roche.h"

int ReadModel(Roche * R, LimbDark * LD, char * name, char * sModelfile) {

  FILE *fm; char line[80]; int ifread=0;

  //printf("In ReadModels\n");
  if ((fm = fopen(sModelfile, "r")) != NULL) {
    for (;;) {
      if (fgets(line, 80, fm) == NULL) {
	if (ifread != 1023) {
	  printf("Didn't get all the data needed from the model.dat ");
	  printf("file: ifread=%3i\n",ifread);
	  printf("missing:\n");
	  ifread=1023-ifread;
	  if (ifread >= 512) {
	    printf("R.fEpoch\n");
	    ifread-=512;
	  }
	  if (ifread >= 256) {
	    printf("R.fDec\n");
	    ifread-=256;
	  }
	  if (ifread >= 128) {
	    printf("R.fRA\n");
	    ifread-=128;
	  }
	  if (ifread >= 64) {
	    printf("LD.sInstrument\n");
	    ifread-=64;
	  }
	  /*
	  if (ifread >= 64) {
	    printf("R.fAngDiam_pB\n");
	    ifread-=64;
	  }
	  */
	  if (ifread >= 32) {
	    printf("R.fTeffp\n");
	    ifread-=32;
	  }
	  if (ifread >= 16) {
	    printf("R.fRNot\n");
	    ifread-=16;
	  }
	  if (ifread >= 8) {
	    printf("R.fMass\n");
	    ifread-=8;
	  }
	  if (ifread >= 4) {
	    printf("LD.sWaveset[]\n");
	    ifread-=4;
	  }
	  if (ifread >= 2) {
	    printf("LD.sLDLaw[]\n");
	    ifread-=2;
	  }
	  if (ifread >= 1) {
	    printf("name[]\n");
	    ifread-=1;
	  }
	  return EXIT_FAILURE;
	}

	//printf("End of file, returning...\n");
	return EXIT_SUCCESS;
      }
      if (strstr(line,"name[]") != NULL) {
	strtok(line,"\"");
	strcpy(name,(strtok(NULL,"\"")));
	strcpy(R->sName, name); // and save it
	//printf("name= %s \n", name);
	ifread+=1;
      }
      else if (strstr(line,"sLDLaw[]") != NULL) {
	strtok(line,"\"");
	strcpy(LD->sLDLaw,(strtok(NULL,"\"")));
	//printf("LDLaw= %s \n", LD->sLDLaw);
	ifread+=2;
      }
      else if (strstr(line,"sWaveset[]") != NULL) {
	strtok(line,"\"");
	strcpy(LD->sWaveset,(strtok(NULL,"\"")));
	//printf("R.sWaveset= %s \n", LD->sWaveset);
	ifread+=4;
      }
      else if (strstr(line,"fMass") != NULL) {
	strtok(line,"=");
	R->fMass=atof(strtok(NULL,";"));
	//printf("R.fMass= %8.2f \n", R->fMass);
	ifread+=8;
      }
      else if (strstr(line,"fRNot") != NULL) {
	strtok(line,"=");
	R->fRNot=atof(strtok(NULL,";"));
	//printf("R.fRNot= %8.3f \n", R->fRNot);
	ifread+=16;
      }
      else if (strstr(line,"fTeffpB") != NULL) {
	strtok(line,"=");
	R->fTeffpB=atof(strtok(NULL,";"));
	//printf("R.fTeffpB= %8.0f \n", R->fTeffpB);
	ifread+=32;
      }
      /*
      else if (strstr(line,"fAngDiam_pB") != NULL) {
	strtok(line,"=");
	R->fAngDiam_pB=atof(strtok(NULL,";"));
	//printf("R.fAngDiam_pB= %6.2f \n", R->fAngDiam_pB);
	ifread+=64;
      }
      */
      else if (strstr(line,"sInstrument[]") != NULL) {
	strtok(line,"\"");
	strcpy(LD->sInstrument,(strtok(NULL,"\"")));
	//printf("Instrument= %s \n", LD->sInstrument);
	ifread+=64;
      }
      else if (strstr(line,"fRA") != NULL) {
	strtok(line,"=");
	R->fRA=atof(strtok(NULL,";"));
	//printf("R.fRA= %8.0f \n", R->fRA);
	ifread+=128;
      }
      else if (strstr(line,"fDec") != NULL) {
	strtok(line,"=");
	R->fDec=atof(strtok(NULL,";"));
	//printf("R.fDec= %8.0f \n", R->fDec);
	ifread+=256;
      }
      else if (strstr(line,"fEpoch") != NULL) {
	strtok(line,"=");
	R->fEpoch=atof(strtok(NULL,";"));
	//printf("R.fEpoch= %8.0f \n", R->fEpoch);
	ifread+=512;
      }
      else {
	printf("didn't recognize the following line in the");
	printf(" model.dat file\n%s\n",line);
	printf("continuing...");
      }
    }
  }
  else {
    printf("Model Data File Empty!  Bailing out.");
    return EXIT_FAILURE;
  }

  //return EXIT_FAILURE;
  return EXIT_SUCCESS;
}
