PRO moll_sph_xy
;+NAME/ONE LINE DESCRIPTION OF ROUTINE:
;    mol_sph_xy build the mollweide projection grid interpolation tables.
;
;DESCRIPTION:
;
;    This procedure generates the interpolation tables used by UV2PROJ
;    to create the coordinate gird overlays for the Mollweide projections.
;    The first table, "phi_out", is simply the latitude in quarter 
;    degree increments.  The second, "theta_out", gives the "scaling"
;    angle.  This table is generated by interating on the expresion:
;
;                     pi*sin(phi) - 2*theta - sin(2*theta)
;    theta = theta +  ------------------------------------
;                           2 * (1 + cos(2*theta))
;
;CALLING SEQUENCE:
;    moll_sph_xy
;
;ARGUMENTS (I = input, O = output, [] = optional):
;
; No input or output arguments.  Results passed via common.
;
;WARNINGS:
;    None
;
;EXAMPLE: 
;
;    None.  Not user routine.
;
;#
;COMMON BLOCKS:
;    mollweide
;
;PROCEDURE (AND OTHER PROGRAMMING NOTES):
;
;    Choose initial interation value for theta.
;    Interatate until convergence.
;
;PERTINENT ALGORITHMS, LIBRARY CALLS, ETC.:
;    None
;
;MODIFICATION HISTORY
;    Written by J.M. Gales, Applied Research Corp.   May 92
;
; SER 9956    Improved Documentation/Banner
; 9-SEP-92    J.M. Gales
;-
COMMON mollweide, phi_out, theta_out

n_pnts = 360
phi_out = dblarr(n_pnts+1)
theta_out = dblarr(n_pnts+1)

; Set boundary values
; -------------------
phi_out(0) = 0.0
theta_out(0) = 0.0

phi_out(n_pnts) = !dpi / 2
theta_out(n_pnts) = !dpi / 2


FOR i=1,n_pnts-1 DO BEGIN

	phi = i * !dpi / (2 * n_pnts)

	theta0 = 100.
	theta = phi
	n=0

	WHILE (ABS(theta-theta0) GT 0.000001) DO BEGIN

		theta0 = theta

		num = !dpi*sin(phi) - 2*theta0 - sin(2*theta0)
		den = 2 + 2 * cos(2*theta0)

		theta = theta0 + (num/den)

		n = n + 1

	ENDWHILE

	phi_out(i) = phi
	theta_out(i) = theta

ENDFOR

RETURN
END
;DISCLAIMER:
;
;This software was written at the Cosmology Data Analysis Center in
;support of the Cosmic Background Explorer (COBE) Project under NASA
;contract number NAS5-30750.
;
;This software may be used, copied, modified or redistributed so long
;as it is not sold and this disclaimer is distributed along with the
;software.  If you modify the software please indicate your
;modifications in a prominent place in the source code.  
;
;All routines are provided "as is" without any express or implied
;warranties whatsoever.  All routines are distributed without guarantee
;of support.  If errors are found in this code it is requested that you
;contact us by sending email to the address below to report the errors
;but we make no claims regarding timely fixes.  This software has been 
;used for analysis of COBE data but has not been validated and has not 
;been used to create validated data sets of any type.
;
;Please send bug reports to CGIS@ZWICKY.GSFC.NASA.GOV.


