/***************************************************************************
 *                                                                         *
 *                               fitOmatic                                 *
 *                   Model-fitting prototyping utility                     *
 *                                                                         *
 *                    Copyright 2007-2012, F. Millour                      *
 *                            fmillour@oca.eu                              *
 *                                                                         *
 ***************************************************************************
 *
 * This is the starting script.
 *
 * Please note that this script is distributed under the GPL licence,
 * available at http://www.gnu.org/licenses/gpl.txt
 *
 * Please ACKNOWLEDGE the use of this script for any use in a publication
 *
 ***************************************************************************
 *
 * $Id: fitOmatic.i 674 2017-02-10 14:19:00Z fmillour $
 *
 ***************************************************************************/

func fitOmatic(void)
    /* DOCUMENT fitOmatic

       DESCRIPTION
       "Automatic" model-fitting tool based on simulated annealing algorithms.
       
       VERSION
       $Revision: 674 $

       REQUIRE
       amdlibPipeline.i
       yoco packages (yoco.i)

       CAUTIONS
       This software is a PROTOTYPE. It should NOT be used for
       publication unless aware that it CAN produce WRONG results!

       AUTHORS
       F. Millour, A. Meilland, V. Girault, B. Valat
       See also the AUTHORS file at the root of the directory distribution
       
       PAPERS
       Here is a (non-exhaustive) list of papers that made use of fitOmatic:
       Domiciano et al. 2008 A&A, 489, 5       : Uniform disks
       Meilland et al.  2008 A&A, 488, 67      : Point sources and uniform disks
       Millour et a.    2009 A&A, 507, 317     : Gaussian disk, resolved component
       Millour et al.   2009 A&A, 506, 49      : Rings, pinwheel
       Chiavassa et al. 2010 A&A, 511, 51      : UD, point sources, resolved source
       Millour et al.   2011 A&A, 526, 107     : Gaz+dust rotating disk
       Chesneau et al.  2014 A&A, 563, 71      : Uniform disk, Gaussian disk, point source
       Chesneau et al.  2014 A&A, 569, 3       : Uniform disks, resolved component
       Chesneau et al.  2014 A&A, 569, 4       : Uniform disks, point sources
       Fabas et al. submitted                  : Uniform disks, Gaussian disks
       Lamberts et al. in prep                 : point sources
       Sanchez et al. SPIE2016 (beauty contest): point sources, uniform disk, skewed ring, Gaussian
       
       The following parameters are relevant for the following models:
       ______________________________________________________________
       | Type    |  Model    |spec| p2  | p3  | p4  | p5  | p6  |  p7 |
       |---------|-----------|----|-----|-----|-----|-----|-----|-----|
       | ful     |resolved   |flux| -   |-    |  -  |  -  |  -  |  -  |
       
       | no      |point      |flux| x0  | y0  |  -  |  -  |  -  |  -  |
       
       | ud      |UD         |flux| x0  | y0  |diam |  -  |  -  |  -  |
       | g       |Gauss      |flux| x0  | y0  |FWHM |  -  |  -  |  -  |
       | r       |ring       |flux| x0  | y0  |diam |  -  |  -  |  -  |
       | l       |Lorentzian |flux| x0  | y0  |fwhm |  -  |  -  |  -  |
       | exp     |exponential|flux| x0  | y0  |k0   |  -  |  -  |  -  |
       | pwr     |power law  |flux| x0  | y0  |pow  |  -  |  -  |  -  |
       | sq      |square     |flux| x0  | y0  |size |  -  |  -  |  -  |
       
       | ldl     |LDD lin    |flux| x0  | y0  |size |epsil|  -  |  -  |
       | ldl     |limbUD     |flux| x0  | y0  |diam |ulam |  -  |  -  |
       | rg      |g ring     |flux| x0  | y0  |diam |FWHM |  -  |  -  |
       | rud     |UD ring    |flux| x0  | y0  |diam |diam3|  -  |  -  |
       | rr      |r ring     |flux| x0  | y0  |diam |diam3|  -  |  -  |
       
       | ud2     |eUD        |flux| x0  | y0  |diam1|diam2|angle|  -  |
       | g2      |eGauss     |flux| x0  | y0  |FWHM1|FWHM2|angle|  -  |
       | r2      |eRing      |flux| x0  | y0  |diam1|diam2|angle|  -  |
       | sq2     |rectangle  |flux| x0  | y0  |size1|size2|angle|  -  |
       
       | ld3     |limbUDpow  |flux| x0  | y0  |diam |ulam |vlam |wlam |
       | rg2     |g eRing    |flux| x0  | y0  |diam1|diam2|angle|FWHM |
       | rud2    |UD eRing   |flux| x0  | y0  |diam1|diam2|angle|diam3|
       | rr2     |r eRing    |flux| x0  | y0  |diam1|diam2|angle|diam3|
       | skwr    |skwedring  |flux| x0  | y0  |size |thick|angSk|ampSk|
       --------------------------------------------------------------
       __________________________________________________________________________
       | Type    |  Model    |spec| p2  | p3  | p4  | p5  | p6  | p7  | p8  | p9  |________
       |---------|-----------|----|-----|-----|-----|-----|-----|-----|-----|-----| p10    |
       | skwr2   |e_skwedring|flux| x0  | y0  |size1|size2|angle|thick|angSk|ampSk|--------|_________________________________
       | pwhl    |pinwheel   |flux|round|mnThk|mxThk|sz   |pw   |phi  |  i  |omega|tail    | p11    | p12         | p13      |
       | 2pwhl   |double pwhl|flux|round|mnThk|mxThk|sz   |pw   |phi  |  i  |omega|tail    |--------|-------------|----------|
       | pwhltl  |pinwheel   |flux|round|mnThk|mxThk|sz   |pw   |phi  |  i  |omega|PowerLaw|tempInit|amplitudeSine|amortiSine|___________________________________________
       |         |temp Law   |    |     |     |     |     |     |     |     |Decr | -      |  -     |  -          | -        | p14   | p15   | p16    | p17   |p18 | p19 |
       | orb     |orbitin obj|flux| x0  | y0  |diam |type | t0  | ecc |majAx| per | i      | omega  |OMEGA        |          |-------|-------|--------|-------|----|-----|
       | orb2    |orbitin bin|flux| x0  | y0  |fxRat|diam1|diam2|type1|type2| M1  | M2     | t0     |eccentricity | maj Axis |period | i     | omega  | OMEGA |    |     |
       | disk    |rotgasdisk |fxS |rStar|deepS|wdtS |fxLin|szCnt|szLne|beta |vrot |vinf    |v0      |gamma        |lineCen   |lineWdt|incl   |pasky   |       |    |     |
       |exprotdsk|rotgasdskSI|fxRa|fxStr|rStar|deepS|wdtS |dst  |szCnt|szLne|incl |beta    |vrot    |vinf         |v0        |gamma  |lineCen|lineWdt |pasky  |    |     |
       | gdisk   |gasdustdisk|fxS |rStar|deepS|wdtS |fxG  |szCnt|szLin|beta |vrot |vinf    |v0      |gamma        |lineCen   |lineWdt|fxDust |FWHMDust|thkDust|incl|pasky|
       |_________|___________|____|_____|_____|_____|_____|_____|_____|_____|_____|________|________|_____________|__________|_______|_______|________|_______|____|_____|


       SEE ALSO visModels,
       testBinaryEphemeris, testModelFit, testPhotocentreModels,
       testSimuInterf, testVisModels, 
       visModeFitUtils, imaModels, latexUtils, photocentreModels,
       simuInterf, amplData, amplStructures, binaryEphemeris, imagingStuff,
    */
{
    version = strpart(strtok("$Revision: 674 $",":")(2),2:-2);
    if (am_subroutine())
    {
        help, fitOmatic;
    }
    return version;
} 

/***************************************************************************/
/*** Necessary includes for fitOmatic **************************************/
/***************************************************************************/

require,"amdlibPipeline.i";
include,"gauss.i"; // gauss.i de yutils, a telecharger par exemple sur http://ubuntu.mirror.server4you.net/ubuntu/pool/universe/y/yorick-yutils/yorick-yutils_1.5.0.orig.tar.gz

//***************************************************************************/
//*** fitOmatic necessary variables
//***************************************************************************/

// Configure amdlib properly
amdlibSetPreference,"errorEnable",1;
amdlibSetPreference,"debugEnable",1;
amdlibSetPreference,"fileChooser","new";
amdlibSetPreference,"graphicsDpi",70;

//***************************************************************************/

yv = Y_VERSION;
major = yocoStr2Double(strpart(yv,1:3));
minor = yocoStr2Double(strpart(yv,-1:0));
write,"Checking yorick version...";
if(major==2.1)
{
    if(minor>=7)
        write,"OK";
    if(minor<7)
        error,"yorick version not OK. You should install >= 2.1.07";
}
if(major>2.1)
{
    write,"OK";
}

write,"#include,\"fitOmatic.i\"";
require, "amplData.i";
require, "amplStructures.i";
require, "lmfit.i";
require, "visModels.i";
require, "imaModels.i";
require, "visModelFitUtils.i";
require, "photocentreModels.i";
require, "simuInterf.i";
require, "binaryEphemeris.i";
