#! /bin/bash
#******************************************************************************
# Install script for MIRA, inspired from the AMBER DRS installation scripts
#
# (c) 2010 F. Millour
#
# $Log: not supported by cvs2svn $
# $Log: installMira.sh,v $
# Revision 1.2  2010/07/27 14:45:29  fmillour
# Add yorickinstallation to the MIRA installation script
# + change to MIRA 0.9.10
#
# Latest versions of the different software needed
####################################################
yeti_URL=https://github.com/emmt/Yeti/archive
yeti_version=6.4.1
MIRA_version=1.1.1
MIRA_URL=https://github.com/emmt/MiRA/releases/download/release-${MIRA_version}
#OptimPack_URL=https://codeload.github.com/emmt/OptimPack/zip
#OptimPack_version=3.0.1
OptimPack_version=1.4.0
OptimPack_URL=https://github.com/emmt/OptimPackLegacy/releases/download/release-${OptimPack_version}

## TBD: last version of Mira is now 1.1.1 on github
## https://github.com/emmt/MiRA/archive/release-1.1.1.zip
####################################################
yorick_URL=http://github.com/dhmunro/yorick/archive
yorick_version=2_2_04
####################################################

####################################################
# Get kernel-name and hardware-platform
kernel=`uname -s`
if [ "$kernel" == "Darwin" ];
then
    platform=`uname -p`
    nbproc=`sysctl hw.ncpu | awk '{print $2}'`
else
    platform=`uname -m`
    nbproc=`nproc`
fi

echo -e "Installing MIRA on $kernel/$platform with $nbproc cores...\n"


# Get root directory
currDir=$PWD

################################################################################
# FIXME: here test all necessary software
hash make 2>/dev/null || { echo >&2 "I require make but it's not installed... Aborting. Try this on ubuntu: sudo apt-get install make"; exit 1; }
hash unzip 2>/dev/null || { echo >&2 "I require unzip but it's not installed... Aborting. Try this on ubuntu: sudo apt-get install unzip"; exit 1; }



# Set log file
logFile=$PWD/mira-install.log
rm -f $logFile
touch $logFile
if [ $? != 0 ]
then
    echo "ERROR - could not access log file $logFile"
    exit 1
fi

# Print usage 
function printUsage () {
    echo -e "Usage: `basename $0` [-h] [-y] [-C <dir>] [-F <dir>]"; 
    echo -e "\t-h\tprint this help.";
    exit 0;
}

# Parse command-line parameters
installOpts=""
while getopts "hyC:F:" option
do
    case $option in
	h ) # Help option
            printUsage;
            exit 0;;
	y ) # Assume yes option
            installOpts="$installOpts -$option";;
	* ) # Unknown option
            echo "Invalid option -- $option"
            printUsage;
            exit 1;;
    esac
done

# test first if yorick is installed
echo -e "Checking for the yorick software..." ;
if test `which yorick`;
then
    echo "write, Y_SITE; quit;" > /tmp/getY_site.i
    INSTALL_DIR=`yorick -batch /tmp/getY_site.i`;
    echo -e "yorick found! installation directory is ${INSTALL_DIR}" ;
else
    echo -e "yorick not found! checking if INSTALL_DIR has been set..." ;
# Then test if the INSTALL_DIR directory is set by the user
    if test ${INSTALL_DIR} ;
    then
	echo -e "Installation directory is ${INSTALL_DIR}" ;
# If INSTALL_DIR directory is set by the user but do not exist, create it
        if test ! -d ${INSTALL_DIR} ;
        then
            echo "    Creating ${INSTALL_DIR} ..."
            mkdir ${INSTALL_DIR}
	fi
# Download yorick
        #cd ${INSTALL_DIR}
	cd $currDir
	echo -e "Downloading yorick, version $yorick_version at ${yorick_URL}/y_${yorick_version}.zip into ${PWD} ..."
	wget -N ${yorick_URL}/y_${yorick_version}.zip >> $logFile 2>&1
	if [ $? != 0 ]
	then
	    echo -e "\nERROR - See log file '$logFile' for details."
	    exit 1;
	fi
# Uncompress yorick
	echo -e "Uncompressing the yorick package..."
	unzip -o y_${yorick_version} >> $logFile 2>&1
	if [ $? != 0 ]
	then
	    echo -e "\nERROR - See log file '$logFile' for details."
	    exit 1;
	fi
	if [ $? != 0 ]
	then
	    echo -e "\nERROR - See log file '$logFile' for details."
	    exit 1;
	fi
# Compile yorick
	echo -e "Configuring yorick..."
	cd yorick-y_${yorick_version}
	./configure >> $logFile 2>&1
	if [ $? != 0 ]
	then
	    echo -e "\nERROR - See log file '$logFile' for details."
	    exit 1;
	fi
	echo -e "Compiling yorick..."
	make -j$nbproc relocatable >> $logFile 2>&1
	if [ $? != 0 ]
	then
	    echo -e "\nERROR - See log file '$logFile' for details."
	    exit 1;
	fi
# Install yorick
	echo -e "Installing yorick to ${INSTALL_DIR}..."
	mv yorick-y_${yorick_version}-04.tgz ${INSTALL_DIR}
	cd ${INSTALL_DIR}
	tar xzf yorick-y_${yorick_version}-04.tgz
	export PATH=${INSTALL_DIR}/yorick-y_${yorick_version}/bin:${PATH}
	export LD_LIBRARY_PATH=${INSTALL_DIR}/yorick-${yorick_version}-04/lib:${LD_LIBRARY_PATH}
	echo -e "Done!\n"
	
# test if yorick is installed
	echo -e "Checking yorick installed well..." ;
	if test `which yorick`;
	then
	    echo "write, Y_SITE; quit;" > /tmp/getY_site.i
	    INSTALL_DIR=`yorick -batch /tmp/getY_site.i`;
	    echo -e "yorick found! installation directory is ${INSTALL_DIR}. Please consider adding this path to your PATH variable in your .bashrc or .profile file:\nexport PATH=${INSTALL_DIR}bin/:\$PATH" ;
	    echo "Press <enter> key when you have understood the above message..."
	    read touche
	    case $touche in
		*)	echo "Continuing..."
		    ;;
	    esac
	else
	echo -e "ERROR - yorick not found!"
	exit ;	    
	fi    
	
    else
	echo -e "ERROR - INSTALL_DIR variable, defining the installation directory, is not set !\nTry setting it with the following commands:\nbash shell:\nexport INSTALL_DIR=<your installation directory>\ntcsh shell:\nsetenv INSTALL_DIR <replace with your installation directory>"
	exit ;
    fi
fi


# Get kernel-name and hardware-platform
kernel=`uname -s`
if [ "$kernel" == "Darwin" ];
then
    platform=`uname -p`
else
    platform=`uname -m`
fi

echo -e "Installing the MIRA software on $kernel/$platform...\n"




####################################################
cd $currDir
echo -e "Downloading yeti, version $yeti_version at ${yeti_URL}/v${yeti_version}.zip into ${PWD} ..."
wget -N ${yeti_URL}/v${yeti_version}.zip >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Uncompressing yeti..."
unzip -o v${yeti_version} >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Installing yeti..."
cd Yeti-${yeti_version}
yorick -batch ./config.i --with-regex \
    --with-fftw --with-fftw-defs="-I/usr/local/include" \
    --with-fftw-libs="-L/usr/local/lib -lrfftw -lfftw" \
    --with-gsl --with-gsl-defs="-I/usr/local/include" \
    --with-gsl-libs="-L/usr/local/lib -lgsl -lgslcblas" 
# Tiff library not always installed on target machines
#    --with-tiff --with-tiff-libs="-ltiff" >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
make -j$nbproc clean >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
make -j$nbproc >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
make -j$nbproc install >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
echo -e "\nDone..."
cd ..




####################################################
cd $currDir
echo -e "Downloading OptimPack, version $OptimPack_version at ${OptimPack_URL}/OptimPackLegacy-${OptimPack_version}.tar.bz2 into ${PWD} ..."
wget -N ${OptimPack_URL}/OptimPackLegacy-${OptimPack_version}.tar.bz2 >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Uncompressing OptimPack..."
tar jxvf OptimPackLegacy-${OptimPack_version}.tar.bz2 >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi




####################################################
echo -e "Installing OptimPack..."
cd OptimPackLegacy-${OptimPack_version}/yorick
yorick -batch make.i >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
make -j$nbproc >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
make -j$nbproc install >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi
cd ../..
echo -e "Done!\n"





####################################################
cd $currDir
echo -e "Downloading MIRA, version $MIRA_version at ${MIRA_URL}/mira-${MIRA_version}.tar.bz2 into ${PWD}..."
wget -N ${MIRA_URL}/mira-${MIRA_version}.tar.bz2 >> $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR - See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Uncompressing MIRA..."
echo $PWD
tar jxvf mira-${MIRA_version}.tar.bz2 >> $logFile 2>&1
cd mira-${MIRA_version}/src
echo "--- mira-1.1.1/src/mira.i       2017-01-23 13:22:20.000000000 +0100
+++ /mnt/c/DATA/iVis/mira_pcp.i 2019-06-16 12:37:13.599928700 +0200
@@ -731,7 +731,7 @@
         phi    = oifits_get_visphi(data, db)(select)*MIRA_DEGREE;
         phierr = oifits_get_visphierr(data, db)(select)*MIRA_DEGREE;
         if (cleanup_bad_data) {
-          good = ((amperr > 0.0)&(phierr > 0.0));
+            good = ((amperr >= 0.0)&(phierr > 0.0)&(amperr < 0.1)&(phierr < 60));
           if (cleanup_bad_data > 1) good &= ((amp >= 0.0)&(amp <= 1.0));
           good = where(good);
           if (! is_array(good)) continue;
@@ -767,7 +767,7 @@
         vis2data = oifits_get_vis2data(data, db)(select);
         vis2err  = oifits_get_vis2err(data, db)(select);
         if (cleanup_bad_data) {
-          good = (vis2err > 0.0);
+            good = ((vis2err > 0.0)&(vis2data / vis2err > 1.));
           if (cleanup_bad_data > 1) good &= ((vis2data >= 0.0)&(vis2data <= 1.0));
           good = where(good);
           if (! is_array(good)) continue;
@@ -797,7 +797,7 @@
         phi    = oifits_get_t3phi(data, db)(select)*MIRA_DEGREE;
         phierr = oifits_get_t3phierr(data, db)(select)*MIRA_DEGREE;
         if (cleanup_bad_data) {
-          good = ((amperr > 0.0)&(phierr > 0.0));
+            good = ((amperr >= 0.0)&(phierr > 0.0)&(amperr < 0.1)&(phierr < 60));
           if (cleanup_bad_data > 1) good &= ((amp >= 0.0)&(amp <= 1.0));
           good = where(good);
           if (! is_array(good)) continue;
@@ -2040,7 +2040,7 @@
   db = h_get(master, "vis2");
   if (db) {
     temp = amp(db.idx);
-    grow, relerr, (db.vis2data - temp*temp)/db.vis2err;
+    grow, relerr, (db.vis2data - temp*temp)/(db.vis2err+(db.vis2err==0));
     grow, idx, db.idx;
   }

@@ -2159,7 +2159,7 @@
     eq_nocopy, phi, mira_get_model_vis_phi(master);
     res = arc(db.t3phi - (db.sgn1*phi(db.idx1) +
                           db.sgn2*phi(db.idx2) +
-                          db.sgn3*phi(db.idx3)))/sqrt(db.t3phierr);
+                          db.sgn3*phi(db.idx3)))/sqrt(db.t3phierr+(db.t3phierr==0));

     binsize = 0.2;
     index = long(floor((1.0/binsize)*res + 0.5));
@@ -2207,6 +2207,7 @@
 func _mira_solve_viewer(x, extra)
 {
   extern _mira_window;
+  local eval;
   flags = extra.view;
   if ((flags & (1|2|4|8)) == 0) {
     /* Nothing to display. */
@@ -2555,6 +2556,7 @@
                 ftol=, gtol=, sftol=, sgtol=, sxtol=,
                 gpnormconv=, get_cost=)
 {
+    extern extra
   if (is_void(view)) view = -1; /* default is to show every graphics */

   /* Set default values for optimizer. */
" > mira.patch
patch -i mira.patch mira.i
cd ..
./configure
make install
echo -e "Moving MIRA files into yorick directory..."
mv -f -v src/*.i ${INSTALL_DIR}/i
echo -e "Done!\n"
