#! /bin/bash
#*******************************************************************************
# Install script for amdlib, MIRA, imutils, etc.
#
# (c) 2010 F. Millour
#
# */

# Print usage 
function printUsage () {
    echo -e "Usage: `basename $0` [-h] [-y] [-C <dir>] [-F <dir>]"; 
    echo -e "\t-h\tprint this help.";
    exit 0;
}

# Parse command-line parameters
installOpts=""
while getopts "hyC:F:" option
do
    case $option in
	h ) # Help option
            printUsage;
            exit 0;;
	y ) # Assume yes option
            installOpts="$installOpts -$option";;
	* ) # Unknown option
            echo "Invalid option -- $option"
            printUsage;
            exit 1;;
    esac
done    

# Get kernel-name and hardware-platform
kernel=`uname -s`
if [ "$kernel" == "Darwin" ];
then
    platform=`uname -p`
else
    platform=`uname -m`
fi


# Get root directory
currDir=$PWD

####################################################
package_name=yutils
package_version=1.5.0
download_URL=http://ubuntu.mirror.server4you.net/ubuntu/pool/universe/y/yorick-${package_name}/

# Set log file
logFile=$PWD/${package_name}-install.log
rm -f $logFile
touch $logFile
if [ $? != 0 ]
then
    echo "ERROR - could not access log file $logFile"
    exit 1
fi

echo -e "Installing the ${package_name} software on $kernel/$platform...\n"

####################################################
echo -e "Downloading ${package_name}, version $package_version..."
curl -O ${download_URL}yorick-${package_name}_${package_version}.orig.tar.gz > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Uncompressing package..."
gunzip yorick-${package_name}_${package_version}.orig.tar.gz > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi
tar xf yorick-${package_name}_${package_version}.orig.tar > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi
rm -f yorick-${package_name}_${package_version}.orig.tar > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi

####################################################
echo -e "Installing package..."
cd yorick-${package_name}-${package_version}
yorick -batch make.i > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi
make > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi
make install > $logFile 2>&1
if [ $? != 0 ]
then
    echo -e "\nERROR: See log file '$logFile' for details."
    exit 1;
fi
cd ..
echo -e "\nDone!."
