/***************************************************************************
 *                                                                         *
 *                              fitOmatic                                  *
 *                   Model-fitting prototyping utility                     *
 *                                                                         *
 *                      Copyright 2007, F. Millour                         *
 *                            fmillour@oca.eu                              *
 *                                                                         *
 ***************************************************************************
 *
 * This script contains the running part of fitomatic.
 * Nothing should be touched here!
 *
 * Please note that this script is distributed under the GPL licence,
 * available at http://www.gnu.org/licenses/gpl.txt
 *
 * Please ACKNOWLEDGE the use of this script for any use in a publication
 *
 ***************************************************************************/

// Set windows
if(is_void(killWin))
    killWin = 1;
if(killWin==1)
    yocoGuiWinKill;

startDate = yocoStrReplace(timestamp(),[" ",":"],["_","-"]);

// Set Chi2 and best model value reference file
if(is_void(refFile))
    refFile = "/tmp/fitOmatic_refFile_"+startDate+".txt";


// Set lock file (useful for multiprocessing run of the software)
if(is_void(lockFile))
    lockFile = "/tmp/fitOmatic_lock_"+startDate;

//Load the data
if(!dej)
{
    sci = [];
    // Load science files only 
    amplLoadOiDatas, sci, inOiFile=dataFiles,crl=crl,crr=crr,wlenRange=wlenRange;
    
    // Load uncalibrated data files
    if(!is_void(dataFilesNCal))
    {
        uncal = [];
        amplLoadOiDatas, uncal, inOiFile=dataFilesNCal,crl=crl,crr=crr,wlenRange=wlenRange;
        for(k=1;k<=numberof(uncal);k++)
        {
            // Transform squared visibility into differential visibility
            V2 = *(uncal(k).VIS2DATA);
            if(!is_void(V2))
            {
                // V                  = yocoMathSignedSqrt(V2);
                // Verr               = *(uncal(k).VIS2ERR) / (2 * V);
                // uncal(k).VISAMP    = &(V / V(,avg,)(,-,));
                // uncal(k).VISAMPERR = &(Verr / V(,avg,)(,-,));
                uncal(k).VIS2DATA  = pointer(0);
                uncal(k).VIS2ERR   = pointer(0);
                uncal(k).VISAMP    = pointer(0);
                uncal(k).VISPHI    = pointer(0);
            }
            // dVis = *(uncal(k).VISAMP);
            // if(!is_void(dVis))
            // {
            //     if(allof(dVis==0))
            //     {
            //         uncal(k).VISAMP    = pointer(0) ;
            //         uncal(k).VISAMPERR = pointer(0) ;
                    
            //     }
            // }
        }
        grow,sci,uncal;
    }
    
    dej=1;
    
    // Smaller weight for longer baselines
    if(weighting)
    {
        R = W = [];
        for(kF=1;kF<=numberof(sci);kF++)
        {
            v2 = (*sci(kF).VIS2DATA);
            if(!is_void(v2))
            {
                U    = *sci(kF).UCOORD;
                V    = *sci(kF).VCOORD;
                r    = abs(U,V);
                w    = *sci(kF).EFF_WAVE;
                grow,R,r;
                grow,W,w;
            }
        }
        minR = min(R);

        for(k=1;k<=numberof(sci);k++)
        {
            // Smaller weight for longer baselines
            if(weighting)
            {
                v2 = (*sci(k).VIS2DATA);
                if(!is_void(v2))
                {
                    U    = *sci(k).UCOORD;
                    V    = *sci(k).VCOORD;
                    R    = abs(U,V);
                    v2e  = (*sci(k).VIS2ERR);
                    tmp = v2e * (R(-,) / minR)^weighting;
                    sci(k).VIS2ERR = &tmp;
                    write,k;
                }
            }
        }
    }

        
    for(k=1;k<=numberof(sci);k++)
    {
        // Remove spurious residuals in differential phases
        dPhi = *(sci(k).VISPHI);
        if(!is_void(dPhi))
        {
            wlen = *(sci(k).EFF_WAVE);
            C = exp(1i*dPhi);
            for(l=1;l<=numberof(dPhi(1,));l++)
            {
                tmp = (*(sci(k).VISPHI))(,l);
                tmp = -computeInsDiffPhi(C(,l), wlen);
                //tmp = tmp - avg(tmp);
                (*(sci(k).VISPHI))(,l) = tmp;
            }
        }
    }

    for(k=1;k<=numberof(sci);k++)
    {
        // Transform squared visibility into differential visibility
        if(dVisFromV2)
        {
            V2 = *(sci(k).VIS2DATA);
            if(!is_void(V2))
            {
                V = yocoMathSignedSqrt(V2);
                Verr = *(sci(k).VIS2ERR) / (2 * V);
                sci(k).VISAMP = &(V / V(,avg,)(,-,));
                sci(k).VISAMPERR = &(Verr / V(,avg,)(,-,));
            }
            dVis = *(sci(k).VISAMP);
            if(!is_void(dVis))
            {
                if(allof(dVis==0))
                {
                    sci(k).VISAMP = pointer(0) ;
                    sci(k).VISAMPERR = pointer(0) ;

                }
            }
        }
    }

    for(k=1;k<=numberof(sci);k++)
    {
        // Re-normalize differential visibility after removing band edges
        if(tot.use_dVis==1)
        {
            dVis = *(sci(k).VISAMP);
            if(!is_void(dVis))
            {
                wlen = *(sci(k).EFF_WAVE);
                for(l=1;l<=numberof(dVis(1,));l++)
                {
                    (*(sci(k).VISAMP))(,l) = computeInsDVis(dVis(,l), wlen);
                }
            }
        }
    }
}

// Store data in fit structure
tot.data = &sci;



/*******************************************************/
// initialize the model, putting by default only random values
initModel, tot, typei, isVariable, parNbWlen, 0.0e-6, ifov, sfov;
(*tot.modelVal)(1) = 1;

/*****************************************************/
(*tot.modelVal) = savedVal;

// Initialize field of view of parameters variations:
buildFov,tot,sfov,ifov;

/*******************************************************/
// Necessary for initialization
updateParams,tot,*tot.modelVal;
params = refA = (*tot.param);
/*******************************************************/

// Plot images of the model
if(plotImage==1)
{
    if(nlen==1)
        wl = minLen;
    else
        wl=span(minLen, maxLen,nlen);

    winkill,2;
    plotModelImageMultiple,tot, params, IMAGECUBE, X, Y, wlen, fov=ifov, Np=npix, plotLog=plotLog, plotPow=plotPow, win=2, kill=1, wlen=wl, cmin=imgcmin, cmax=imgcmax;

    //palette,"heat.gp";
    //palette,"earth.gp";
    if(!is_void(pal))
        palette,pal;
    
    if(psFile)
        hcps,dataDir+"modelImage"+sum("_"+typei)+".ps";
    if(pngFile)
        png,dataDir+"modelImage"+sum("_"+typei)+".png",dpi=300;
    if(saveFits)
        if(is_void(miral_write_imgCube))
            cfitsWrite,dataDir+"modelImagesCube"+sum("_"+typei)+".fits",IMAGECUBE;
        else
            miral_write_imgCube, dataDir+"modelImagesCube"+sum("_"+typei)+".fits",IMAGECUBE(::-1,::-1,),X,Y,wlen;
}

// vectorize the data
dataLine = getDataInLine(*tot.data,
                         tot.use_vis2,
                         tot.use_clos,
                         tot.use_bsamp,
                         tot.use_dVis,
                         tot.use_dPhi,
                         tot.use_spec,
                         dataError,dataType, dataWl,
                         dataU1, dataV1,
                         dataU2, dataV2, dataTime);
tot.dataLine = &dataLine;


if(computeCovMat)
{
    // Buildup the covariance matrix, taking into account the correlations
    // between wavelengths for the squared visibilities
    nbO = numberof(dataLine);

    // Get relevant information to build the covariance matrix
    u1 = (dataU1(-,)==dataU1(,-));
    u2 = (dataU2(-,)==dataU2(,-));
    v1 = (dataV1(-,)==dataV1(,-));
    v2 = (dataV2(-,)==dataV2(,-));
    // Select only squared visibilities
    typ = ((dataType=="V2")(-,)&(dataType=="V2")(,-));

    wdt = 50.e-8;
    att = exp(-(dataWl(-,) - dataWl(,-))^2 / (wdt^2));

    errMat = dataError(-,) * dataError(,-);
    com = // att *
        (u1 & u2 & v1 & v2 & typ);

    covMat = com * errMat + (com==0) * diag(dataError^2);
    invCovMat = LUsolve(covMat);

    tot.dataErrLine = &invCovMat;
    weight = invCovMat;
}

if(!computeCovMat)
{
    tot.dataErrLine = &dataError;
    weight = (dataError!=0) * 1.0/(dataError+(dataError==0))^2;
    // Sort out nans !
    wnan = where(weight!=weight);
    if(numberof(wnan)!=0)
        weight(wnan) = 0;
    //weight = 1./dataError^2;
}

tot.dataType = &dataType;

// Initialize the data weights

// Initialize additional values
updateParVal,tot,params; 

// Get reference projection angle for sp. freq. plots
if(plot ==1)
{
    if(!is_void(refPAx))
        refPA = atan((*tot.modelVal)(refPAx),(*tot.modelVal)(refPAy));

    plotDataSpFreq, *tot.data, projAngle=refPA, kill=killWin, plotVis=plotVis, plotDVis=plotDVis,plotDPhi=plotPhi,plotClos=plotClos,plotSpec=plotSpec,wrap=wrap,limVis=limVis,limDVis=limDVis,limClos=limClos,limDPhi=limDPhi,logVis=logVis,resid=plotRes, limFreq=limFreq, legendHeight=legendHeight,sizebar=sizebar,phaseDeg=phaseDeg;

    if(psFile)
        hcps,dataDir+"dataSpFreq.ps";
    if(pngFile)
        png,dataDir+"dataSpFreq.png",dpi=300;
    //yocoNmLimits,,,-0.1,1.1;

    if(plotParams)
    {
        plotParamsWlen,tot,kill=1,win=6;
        if(psFile)
            hcps,dataDir+"modelWlen"+sum("_"+typei)+".ps"; 
        if(pngFile)
            png,dataDir+"modelWlen"+sum("_"+typei)+".png",dpi=300;
    }
    
    if(plotWlen)
    {
        // Plot visibilities
        if(plotVis)
            plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=1,plotDPhi=0,plotClos=0,limVis=limVis,logVis=logVis,win=10,kill=1,idxData=idxData,color="red";
        
        if(psFile)
            hcps,dataDir+"dataWlen_vis.ps";
        if(pngFile)
            png,dataDir+"dataWlen_vis.png",dpi=300;
        
        // Plot Clos Phases
        if(plotClos)
            plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=0,plotClos=1,limVis=limVis,logVis=logVis,win=11,kill=1,idxData=idxData,color="red",phaseDeg=phaseDeg;
        
        if(psFile)
            hcps,dataDir+"dataWlen_clos.ps";
        if(pngFile)
            png,dataDir+"dataWlen_clos.png",dpi=300;
        
        // Plot Diff Phases
        if(plotPhi)
            plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=1,plotClos=0,limVis=limVis,logVis=logVis,win=12,kill=1,idxData=idxData,color="red",phaseDeg=phaseDeg;
        
        if(psFile)
            hcps,dataDir+"dataWlen_diffPhi.ps";
        if(pngFile)
            png,dataDir+"dataWlen_diffPhi.png",dpi=300;

        
        // Plot Diff Vis
        if(plotDVis)
            plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=1,plotVis=0,plotDPhi=0,plotClos=0,limVis=limVis,logVis=logVis,win=13,kill=1,idxData=idxData,color="red";
        
        if(psFile)
            hcps,dataDir+"dataWlen_diffVis.ps";
        if(pngFile)
            png,dataDir+"dataWlen_diffVis.png",dpi=300;
        
        // Plot Spectra
        if(plotSpec)
            plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=0,plotSpec=1,plotClos=0,limVis=limVis,limSpec=limSpec,logVis=logVis,win=14,kill=1,idxData=idxData,color="red";

        
        if(psFile)
            hcps,dataDir+"dataWlen_spec.ps";
        if(pngFile)
            png,dataDir+"dataWlen_spec.png",dpi=300;
        
        //yocoNmLimits,,,-0.1,1.1;
    }
    // plotAllDataAbsAndDif,*tot.data, width=3;
}

if(stopPlotData)
    stophere();

// Initialize simulated annealing temperature
temp = temp0;

// Loop on several steps to do some kind of global optimization
//kIt=1;


// Measure execution time
elapsed = array(double,3);
timer,elapsed;
time0 = elapsed(0);
time = time0+2;

for(kIt=1;kIt<=maxIT;kIt++)
{
    dt = time - time0;
    elapsed = array(double,3);
    timer, elapsed;
    time = elapsed(0);
    if(dt>=1)
    {
        write,"Test "+pr1(kIt),"| Temperature "+pr1(temp),"| Ref. Chi2 "+pr1(refChi2),"| Chi2 "+pr1(chi2);
        time0 = time;
    }
    // Store previous chi squared

    if(kIt>2)
    {
        temp *= 1.-decr;
        if(temp < prec)
            temp = temp0;

        addPar = refA*temp*random_n(numberof(refA));

        params = sign(random(numberof(refA))-0.05) * (refA + addPar);
    }
    //print,params;

    // This loop is interesting because sometimes the lmfit procedure comes
    //to a local minimum and iterating on it allow to converge faster.
    do
    {
        // if(computeCovMat)
        // memo=trfitmemo(itmax=itmax,dataCovMat=&covMat,stdev=&dataError);
        // if(!computeCovMat)
        // memo=trfitmemo(itmax=itmax,dataCovMat=&[],stdev=&dataError);

        // od is a marker to stop fit and only plot the model on the data
        if((od==0)&&(kIt!=1)&&fitLM)
        {
            r = trfit(resFunc,tot,params,quiet=1,memo=memo);

            // Plot evolution of chi2 during current fit
            yocoNmCreate,4,landscape=1,wait=1,V = [0.1,0.9,0.12,0.73],fx=1;
            fma;
            plg,*r.chi2_tracks;
            logxy,,1;
            yocoNmCreate,5,height=100,width=100;
        }

        chi2 = computeChi2(tot, params, dataLine, weight, dataType);
        nPar = numberof(params);
        
        /////////////////////////////////////////////////////////////////////
        // Read reference Chi2 from file
        // First check that no other instance of the same process is running
        // and wait until the access is free
        while(open(lockFile,"r",1))
        {
            write,"Waiting for lock release";
            pause,10;
        }
        // Lock the process the time to work on the file
        fh = open(lockFile,"w");
        write,fh,"locked "+timestamp();
        close,fh;
        // In case the ref file does not exist, write the current values in it
        if(!open(refFile,"r",1))
        {
            fh = open(refFile,"w");
            for(k=1;k<=nPar;k++)
                write,fh,params(k), linesize=100, format="%1.73e \n";
            write,fh,chi2, format="%1.73e ";
            close,fh;
        }
        // Read the best chi2 and the best value of parameters
        dat     = yocoFileReadAscii(refFile);
        refA    = yocoStr2Double(dat(1,:-1));
        refChi2 = yocoStr2Double(dat(1,0));
        remove,lockFile;
        /////////////////////////////////////////////////////////////////////

        //  write,kIt,chi2,refChi2;
        
        compar = abs(chi2-refChi2);

        managedChi2 = 0;

        if(chi2<=refChi2)
        {
            managedChi2 = 1;

            refChi2 = chi2;
            updateParVal,tot,params;

            getRefModel, tot, refMod;
            refA = *refMod.param;

            /////////////////////////////////////////////////////////////////
            // Write reference chi2 to file
            // First check that no other instance of the same process is running
            // and wait until the access is free
            while(open(lockFile,"r",1))
            {
                write,"Waiting for lock release";
                pause,10;
            }
            // Lock the process the time to work on the file
            fh = open(lockFile,"w");
            write,fh,"locked "+timestamp();
            close,fh;
            // Write reference Chi2 to file            
            fh = open(refFile,"w");
            for(k=1;k<=nPar;k++)
                write,fh,params(k), linesize=100, format="%1.73e \n";
            write,fh,refChi2, format="%1.73e ";
            close,fh;
            remove,lockFile;
            /////////////////////////////////////////////////////////////////
                    
            // Keep temperature constant by counteracting the
            // forthcoming temperature decrease
            temp /= 1.-decr;

            // Write stuff
            write,model;
            nfree = numberof(dataLine)-nPar;
            write,"Chi2",chi2, "Red. Chi2",chi2/(nfree+(nfree==0)),
                "Red. Chi22",chi2/(nfree+(nfree==0)) * nPar;
            print,*tot.modelVal;

            if(writePars)
                writeParams,tot;

            toto = (chi2-refChi2);
            titi = 1.0/(toto+1e-9*(toto==0));

            if(!is_void(addPar)&&(nPar==numberof(addPar)))
            {
                params = refA + addPar;
                addPar += 0.5*addPar;
            }

            if(plot==1)
            {
                if(!is_void(refPAx))
                    refPA = atan((*refMod.modelVal)(refPAx),(*refMod.modelVal)(refPAy));

                if(plotParams)
                {
                    plotParamsWlen,tot,clear=1,kill=0,win=6;
                    if(psFile)
                        hcps,dataDir+"modelWlen"+sum("_"+typei)+".ps";
                    if(pngFile)
                        png,dataDir+"modelWlen"+sum("_"+typei)+".png",dpi=300;
                }



                plotDataSpFreq, *refMod.data, projAngle=refPA, clear=1, plotVis=plotVis, plotDVis=plotDVis,plotDPhi=plotPhi,plotClos=plotClos,plotSpec=plotSpec,wrap=wrap,limVis=limVis,limDVis=limDVis,limClos=limClos,limDPhi=limDPhi,logVis=logVis,resid=plotRes, limFreq=limFreq,color=dataColor, legendHeight=legendHeight,sizebar=sizebar,phaseDeg=phaseDeg;

                if(plotRes==1)
                    plotResSpFreq,*refMod.data,*refMod.model,projAngle=refPA,clear=0,plotVis=plotVis,plotDVis=plotDVis,plotDPhi=plotPhi,plotClos=plotClos,wrap=0, kill=0, model=1, type="none",marker='\4', limFreq=limFreq,limVis=limVisRes,limDVis=limDVisRes,limClos=limClosRes, limSpec=limSpecRes,limDPhi=limDPhiRes,color=dataColor,phaseDeg=phaseDeg;
                
                plotDataSpFreq,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=plotVis,plotDVis=plotDVis,plotDPhi=plotPhi,plotClos=plotClos,plotSpec=plotSpec,wrap=wrap, clear=0, kill=0,logVis=logVis, resid=plotRes,limVis=limVis,limClos=limClos,limDPhi=limDPhi,limDVis=limDVis, legendHeight=legendHeight,sizebar=sizebar,phaseDeg=phaseDeg;

                plotDataSpFreq,*tot.model,color="black",model=1, width=2 ,projAngle=refPA, plotVis=plotVis,plotDVis=plotDVis,plotDPhi=plotPhi,plotClos=plotClos,plotSpec=plotSpec,wrap=wrap, clear=0, kill=0,logVis=logVis, resid=plotRes,limVis=limVis,limClos=limClos,limDPhi=limDPhi,limDVis=limDVis, legendHeight=legendHeight,sizebar=sizebar,phaseDeg=phaseDeg;

                psname = dataDir+"dataModelSpFreq"+sum("_"+typei)+".ps";
                if(psFile)
                    hcps,psname;
                pngname = dataDir+"dataModelSpFreq"+sum("_"+typei)+".png";
                if(pngFile)
                    png,psname,dpi=300;
                // require,"chg_bbox.i";
                //chg_bbox,psname,[0,0,600,800];
                //yocoNmLimits,,,-0.1,1.1;
                //window,3;
                //fma;

                if(plotWlen)
                {
                    // Plot visibilities
                    if(plotVis)
                    {
                        plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=plotVis,plotDPhi=0,plotClos=0,limVis=limVis,logVis=logVis,win=10,kill=0,idxData=idxData,color="red";
                        plotDataWlen,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=plotVis,plotDVis=0,plotDPhi=0,plotClos=0,clear=0,win=10,idxData=idxData;

                        plotDataWlen,*tot.model,color="black",model=1, width=2 ,projAngle=refPA,plotVis=plotVis,plotDVis=0,plotDPhi=0,plotClos=0,clear=0,win=10,idxData=idxData;

                    if(psFile)
                        hcps,dataDir+"dataModelWlen_vis"+sum("_"+typei)+".ps"; 
                    if(pngFile)
                        png,dataDir+"dataModelWlen_vis"+sum("_"+typei)+".png",dpi=300; 
                    }

                    // Plot Closure Phases
                    if(plotClos)
                    {
                        plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=0,plotClos=1,limVis=limVis,logVis=logVis,win=11,kill=0,idxData=idxData,color="red",phaseDeg=phaseDeg;
                        plotDataWlen,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=0,plotDVis=0,plotDPhi=0,plotClos=1,clear=0,win=11,idxData=idxData,phaseDeg=phaseDeg;

                        plotDataWlen,*tot.model,color="black",model=1, width=2 ,projAngle=refPA,plotVis=0,plotDVis=0,plotDPhi=0,plotClos=1,clear=0,win=11,idxData=idxData,phaseDeg=phaseDeg;

                    if(psFile)
                        hcps,dataDir+"dataModelWlen_clos"+sum("_"+typei)+".ps"; 
                    if(pngFile)
                        png,dataDir+"dataModelWlen_clos"+sum("_"+typei)+".png",dpi=300; 
                    }

                    // Plot Diff Phases
                    if(plotPhi)
                    {
                        plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=1,plotClos=0,limVis=limVis,logVis=logVis,win=12,kill=0,idxData=idxData,color="red",phaseDeg=phaseDeg;
                        plotDataWlen,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=0,plotDVis=0,plotDPhi=1,plotClos=0,clear=0,win=12,idxData=idxData,phaseDeg=phaseDeg;

                        plotDataWlen,*tot.model,color="black",model=1, width=2 ,projAngle=refPA,plotVis=0,plotDVis=0,plotDPhi=1,plotClos=0,clear=0,win=12,idxData=idxData,phaseDeg=phaseDeg;

                    if(psFile)
                        hcps,dataDir+"dataModelWlen_diffPhi"+sum("_"+typei)+".ps"; 
                    if(pngFile)
                        png,dataDir+"dataModelWlen_diffPhi"+sum("_"+typei)+".png",dpi=300; 
                    }

                    // Plot Diff Visibilities
                    if(plotDVis)
                    {
                        plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=1,plotVis=0,plotDPhi=0,plotClos=0,limVis=limVis,logVis=logVis,win=13,kill=0,idxData=idxData,color="red";
                        plotDataWlen,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=0,plotDVis=1,plotDPhi=0,plotClos=0,clear=0,win=13,idxData=idxData;

                        plotDataWlen,*tot.model,color="black",model=1, width=2 ,projAngle=refPA,plotVis=0,plotDVis=1,plotDPhi=0,plotClos=0,clear=0,win=13,idxData=idxData;

                    if(psFile)
                        hcps,dataDir+"dataModelWlen_diffVis"+sum("_"+typei)+".ps"; 
                    if(pngFile)
                        png,dataDir+"dataModelWlen_diffVis"+sum("_"+typei)+".png",dpi=300; 
                    }

                    // Plot Spectra
                    if(plotSpec)
                    {
                        plotDataWlen,*tot.data,projAngle=refPA,clear=1,plotDVis=0,plotVis=0,plotDPhi=0,plotClos=0,plotSpec=1,limVis=limVis,limSpec=limSpec,logVis=logVis,win=14,kill=0,idxData=idxData,color="red";

                        plotDataWlen,*refMod.model,color=[192,192,192],model=1, width=2 ,projAngle=refPA, plotVis=0,plotDVis=0,plotDPhi=0,plotClos=0,plotSpec=1,clear=0,win=14,idxData=idxData,limSpec=limSpec;

                        plotDataWlen,*tot.model,color="black",model=1, width=2 ,projAngle=refPA,plotVis=0,plotDVis=0,plotDPhi=0,plotClos=0,plotSpec=1,clear=0,win=14,idxData=idxData,limSpec=limSpec;

                    if(psFile)
                        hcps,dataDir+"dataModelWlen_spec"+sum("_"+typei)+".ps"; 
                    if(pngFile)
                        png,dataDir+"dataModelWlen_spec"+sum("_"+typei)+".png",dpi=300; 
                    }

                } 
                if(plotImage==1)
                {
                    if(nlen==1)
                        wl = minLen;
                    else
                        wl=span(minLen, maxLen,nlen);

                    plotModelImageMultiple,tot, params, IMAGECUBE, fov=ifov, Np=npix, plotLog=plotLog, plotPow=plotPow, win=2, clear=1, kill=0, wlen=wl,cmin=imgcmin,cmax=imgcmax;

                    // palette,"heat.gp";
                    // palette,"rainbow.gp";
                    //palette,"earth.gp";
                    if(!is_void(pal))
                        palette,pal;

                    if(psFile)
                        hcps,dataDir+"dataWlen_model"+sum("_"+typei)+".ps";
                    if(pngFile)
                        png,dataDir+"dataWlen_model"+sum("_"+typei)+".png",dpi=300;
                }


                //window,3;
                //fma;
                // hcps,"~/modelImages.ps";
                // cfitsWrite,HOME+"modelImagesCube.fits.gz",IMAGECUBE;
                // plotAllDataAbsAndDif,*refMod.data, width=3, clear=1;
                // plotAllDataAbsAndDif,*refMod.model,color=[192,192,192],model=1, width=1;
                // plotAllDataAbsAndDif,*tot.model,color="black",model=1, width=1;
                if(plotParams)
                {
                    plotParamsWlen,tot,kill=0,win=6;
                }

            }
        }


        if(od==1)
        {
            // window,1;
            //hcps,"~/data.ps";
            // require,"chg_bbox.i";
            // chg_bbox,HOME+"/data.ps";
            write,"Stopped here because od equals one";
            break;
        }
    }
    while((compar>prec)&&(chi2<=refChi2));

    if(od==1)
    {
        break;
    }
} 


//getParamsErrors,tot;
// hcps,"~/modelErrors.ps";

if(plotParams)
{
    plotParamsWlen,tot,win=6;
}
//hcps,"~/modelWlen.ps"; 

