/***************************************************************************
 *                                                                         *
 *                              fitOmatic                                  *
 *                   Model-fitting prototyping utility                     *
 *                                                                         *
 *                      Copyright 2007, F. Millour                         *
 *                            fmillour@oca.eu                              *
 *                                                                         *
 ***************************************************************************
 *
 * test of binary ephemeris 
 *
 * Please note that this script is distributed under the GPL licence,
 * available at http://www.gnu.org/licenses/gpl.txt
 *
 * Please ACKNOWLEDGE the use of this script for any use in a publication
 *
 ***************************************************************************
 *
 * "@(#) $Id: testBinaryEphemeris.i 566 2015-02-07 16:27:40Z fmillour $"
 *
 * History
 * -------
 * $Log: not supported by cvs2svn $
 * Revision 1.8  2010/08/09 13:48:23  fmillour
 * put back revision number and initial revision
 *
 * Revision 1.1  2010/06/14 07:21:38  fmillour
 * Add yorick directory
 *
 * Revision 1.7  2010/06/11 16:20:36  fmillour
 * Update of all headers of directly fitOmatic-related scripts, in order to have them harmonized. This is first step before a better software organization, with idea to distribute it at some point
 *
 * Revision 1.6  2008/08/13 09:12:30  fmillour
 * correction: consider the scripts will be always in "~/CVS/fitOmatic/"
 *
 * Revision 1.5  2008/06/20 16:03:07  fmillour
 * modifs to get better demos
 *
 * Revision 1.4  2007/09/26 09:06:51  fmillour
 * better handling of date
 *
 * Revision 1.3  2007/08/01 11:38:19  fmillour
 * doc work again
 *
 * Revision 1.2  2007/08/01 11:26:47  fmillour
 * Doc work (mainly)
 *
 * revision 1.1 2007-07-31 19:59:06 +0200;  author: fmillour
 * Initial revision
 *
 ***************************************************************************/

func testBinaryEphemeris(void)
/* DOCUMENT testBinaryEphemeris

       DESCRIPTION
       Standard analytical models for visibilities computation

       AUTHORS
       - Florentin Millour (fmillour@mpifr-bonn.mpg.de)
       Please do NOT distribute this script without the permission of the
       author(s)

       REQUIRE
       - bessel.i

       AUTHORS
       - Florentin Millour (fmillour@mpifr-bonn.mpg.de)
   
       FUNCTIONS
   - testBinaryEphemeris: 
    */
{
    version = strpart(strtok("$Revision: 566 $",":")(2),2:-2);
    if (am_subroutine())
    {
        write, format="package version: %s\n", version;
        help, testBinaryEphemeris;
    }   
    return version;
} 

yocoLogInfo,"#include \"testBinaryEphemeris.i\"";

/***************************************************************************/

require,"binaryEphemeris.i";

/***************************************************************************/

// North et al. ApJ 2007
T0 = 50120.4;
eccentricity = 0.334;
OMEGA  = (247.7) * yocoAstroSI.deg;
omega = (67.4) * yocoAstroSI.deg;
i = (65.5)* yocoAstroSI.deg;
period = 78.53*yocoAstroSI.day;
majorAxis = 3.57 * yocoAstroSI.mas;

//MJD_atObs = getMJD(2008, 4, 10, 0, 0, 0);

//fullDate = "Thu Dec 26 3:48:0 2004";
fullDate = "Thu Dec 20 0:0:0 2008";
// fullDate = "Thu Jan 10 0:0:0 2009";
// fullDate = "Thu Jan 10 0:0:0 2009";
// fullDate = "Thu Jan 10 0:0:0 2009";
// fullDate = "Thu Jan 10 0:0:0 2009";

stamp = yocoStrSplit(fullDate," ");
months = ["Jan","Feb","Mar","Apr","May","Jun",
          "Jul","Aug","Sep","Oct","Nov","Dec"];
month = where(stamp(2)==months)(1);
day = yocoStr2Double(stamp(3));
year = yocoStr2Double(stamp(0));
hours = yocoStrSplit(stamp(-1),":");
hour = yocoStr2Double(hours(1));
minute = yocoStr2Double(hours(2));
second = yocoStr2Double(hours(3));
MJD_atObs = getMJD(year, month, day, hour, minute, second); 

// Millour et al. A&A 2007
// T0 = 2450120.5 - 2400000.5;
// eccentricity = 0.326;
// OMEGA  = (232.7) * yocoAstroSI.deg;
// omega = (68.0) * yocoAstroSI.deg;
// i = (65.0)* yocoAstroSI.deg;
// period = 78.53*yocoAstroSI.day;
// majorAxis = 4.8 * yocoAstroSI.mas; 

// Kraus et al. A&A 2007
// T0 = 1996.52
// eccentricity = 0.909;
// OMEGA  = (56.5-90) * yocoAstroSI.deg;
// omega = 65.7 * yocoAstroSI.deg;
// i = 105.2 * yocoAstroSI.deg;
// period = 10.98*yocoAstroSI.yr;
// majorAxis = 41.3 * yocoAstroSI.mas; 


time = (span(0, period, 1000));
nodeY = span(-4.5,4.5,100);
nodeX = array(0.0,100);
CoordNode = grow(array(nodeX,1),array(nodeY,1));
periX = span(-6.5,3.5,100);
periY = array(0.0,100);
CoordPeri = grow(array(periX,1),array(periY,1)); 



window,1;

CoordOrbit = binaryCoordinates(time,eccentricity,majorAxis,period) / yocoAstroSI.mas;

scale = majorAxis * sqrt((1+eccentricity)/(1-eccentricity)) / yocoAstroSI.mas;
fma;
plg,CoordOrbit(,2),CoordOrbit(,1);
plg,0,0,type="none",marker='\W';
limits,-scale,scale,-scale,scale; 


plg,CoordNode(,2),CoordNode(,1),width=4;

plg,CoordPeri(,2),CoordPeri(,1),type="dash"; 






// MJD_atObs = getMJD(2004, 12, 26, 4, 18, 34);
//  MJD_atObs = getMJD(2008, 12, 10, 0, 0, 0);
// MJD_atObs = getMJD(2009, 1, 10, 0, 0, 0);
timeAtObs = array(MJD_atObs - T0,2)*yocoAstroSI.day;
    
CoordWR = binaryCoordinates(timeAtObs,eccentricity,majorAxis,period,gotPhi) / yocoAstroSI.mas;

//  phase = array(2*pi*(0.32), 2);
//  phase = array(2*pi*(0.03), 2);
//  phase = array(2*pi*(0.61), 2);
// phase = array(2*pi*(0.40), 2);
// phase = array(386.74,2);
// CoordWR = atan(keplerCoordinates(phase,eccentricity,majorAxis) , dst) ;

plg,CoordWR(,2),CoordWR(,1),type="none",marker='\O';
plg,0,0,type="none",marker='\W'; 





window,2;

CoordP2 = RotateOrbit(CoordOrbit,i,omega,OMEGA);

fma;
plg,CoordP2(,2),CoordP2(,1);

CoordNode2 = RotateOrbit(CoordNode,i,omega,OMEGA);
plg,CoordNode2(,2),CoordNode2(,1),width=4;

CoordPeri2 = RotateOrbit(CoordPeri,i,omega,OMEGA);
plg,CoordPeri2(,2),CoordPeri2(,1),type="dash";

CoordWR2 = RotateOrbit(CoordWR,i,omega,OMEGA);
plg,CoordWR2(,2),CoordWR2(,1),type="none",marker='\O';
plg,0,0,type="none",marker='\W';
plg,[0,CoordWR2(1,2)],[0,CoordWR2(1,1)],type="dot"; 


r = abs(CoordWR2(,1),CoordWR2(,2));
theta = (270-180/pi*atan(CoordWR2(,1),CoordWR2(,2)))%360;
write,"rho",r,"PA",theta;
write,"phase",gotPhi/(2*pi);

limits,-scale,scale,-scale,scale;

xytitles,"!d (mas) ---------> N","!a (mas) ---------> E",[0.02,0.02]; 

namz = "~/Star_"+pr1(year)+
    "_"+months(month)+
    "_"+pr1(day)+
    "_"+pr1(hour)+"h"+
    pr1(minute)+"m"+
    pr1(second)+"s"+
    ".ps";

hcps,namz;

include,"chg_bbox.i";
chg_bbox,namz;
