/******************************************************
 *                                                    *
 *                       MIRA-L                       *
 *                                                    *
 *    Add-on script to the MIRA software to handle    *
 *       multi-wavelength datasets, including a       *
 *               self-calibration step                *
 *                                                    *
 *       Copyright F. Millour, MPIFR, OCA 2010        *
 *                  fmillour@oca.eu                   *
 *                All rights reserved                 *
 *                                                    *
 ******************************************************/

/******************************************************/
/*** Necessary include files **************************/
/******************************************************/
include, "mira.i";
require, "fitOmatic.i";
include, "miral.i";

/******************************************************/

func testMiral(void)
/* DOCUMENT testMiral

   Example script on the add-on script to the MIRA software to handle 
   multi-wavelength datasets, including a self-calibration step 
   
   Copyright F. Millour, MPIFR 2010, OCA 2011 
   fmillour@oca.eu 
   All rights reserved 
   
   FUNCTIONS
   - testMiral: This script
   
   SEE ALSO
*/
{
    version = strpart(strtok("$Revision: 546 $",":")(2),2:-2);
    if (am_subroutine())
    {
        help, testMiral;
    } 
    return version;
}

/******************************************************/

datadir = HOME+"/DATA/"; // Put here your AMBER OI FITS data directory
imageClosureOnly = datadir+"/../IMAGE_CLOSURE_PHASE.fits"; // Output image

// First image reconstruction step, with closure phases only
miral_reconstruct_multiwlen, inputFitsFiles, imageClosureOnly, target=, img0=newFirstIma, popVis=1, popV2=0, copV2toV=0, popV3=0, binSize=binSize, recenter=1, pixSize=pixSize, imgSize=imgSize, mu=mu, fovFWHM=, verb=0, prior=priorIma, projAngle=imaPA;

// Self calibration
// 1st put closure phase image into the self cal image (1st step)
selfCalImage = imageClosureOnly;
// Loop on self cal (iterative process)
for(k=1;k<=10;k++)
{
    // Set output self-cal-ed data directory
    datadir2 = sum(yocoStrrtok(datadir,"/"))+"_selfcal"+pr1(k)+"/";

    // Perform self cal
    miral_self_calibrate, datadir, selfCalImage, datadir2;
    
    // define new input oifits files for the next image reconstruction step
    files = lsdir(datadir2);
    inputFitsFiles2 = datadir2 + files(where((!strmatch(files,".ps"))&
                                             (!strmatch(files,"image"))&
                                             strmatch(files,".fits")));
    target = [];

    // Define new output image cube name
    selfCalImage = datadir2+"/../"+templateFile+"_IMAGE_SELFCAL"+pr1(k)+".fits";

    // Perform image reconstruction, using the self-cal-ed phases
    miral_reconstruct_multiwlen(inputFitsFiles2, selfCalImage, target=, img0=newFirstIma, popVis=0, popV2=1, copV2toV=1, popV3=0, binSize=binSize, recenter=0, radius=[], pixSize=pixSize, imgSize=imgSize, mu=mu, fovFWHM=, verb=0, prior=priorIma, projAngle=imaPA);
}

