/***************************************************************************
 *                                                                         *
 *                              fitOmatic                                  *
 *                   Model-fitting prototyping utility                     *
 *                                                                         *
 *                    Copyright 2007-2014, F. Millour                      *
 *                            fmillour@oca.eu                              *
 *                                                                         *
 ***************************************************************************
 *
 * This script contains routines to perform an example fit using all the
 * prototypes routines
 *
 * Please note that this script is distributed under the GPL licence,
 * available at http://www.gnu.org/licenses/gpl.txt
 *
 * Please ACKNOWLEDGE the use of this script for any use in a publication
 *
 ***************************************************************************/

include,"amdlib.i";
amdlibSetPreference,"errorEnable",1;
amdlibSetPreference,"debugEnable",1;

include,"fitOmatic.i";

/*******************************************************/

// Define fit parameters
tot = fitStruct();
dej = 0;
// od is a marker to stop fit and only plot the model on the data
od           = 0;
// Define fit function. Default should be funcMultiple
tot.funcFit  = "funcMultiple";

// Use the different observables. Available for now are squared visibilities,
// closure phases and differential phases.
tot.use_vis2 = 1;
tot.use_clos = 1;
tot.use_bsamp= 0;
tot.use_dPhi = 0;
tot.use_dVis = 0;
tot.use_spec = 0;

// Plot visibilities, closure phases and fdifferential phases
plot     = od;
plotWlen = 1;
plotRes  = od;
plotVis  = 2*tot.use_vis2*plot;
plotPhi  = tot.use_dPhi*plot;
plotClos = tot.use_clos*plot;
plotDVis = (tot.use_dVis > 0)*plot;
plotSpec = 0;
plotImage = od;
logVis   = 0;

// In case to compute absolute value of closure phases. DO NOT USE !
tot.absClos  = 0;

// specify positivity of flux here
tot.absFlux  = 1;
// specify positivity of angular sizes here
tot.absSize  = 1;

// set a reference position angle on which to project data
refPAx       = 0;
refPAy       = -1;

// wrap allow to plot the data unwrapped (does not work so well)
wrap         = 0;

// Maximum iterations of the simulated annealing fit
maxIT        = 100000;
itmax        = 50;

// Initialize the chi2
refChi2      = 1e99;

// For monte-carlo optimization one needs this factor
fac0         = 0.01;
fac          = fac0;
// For monte-carlo optimization one needs this factor
fitLM = 0;
temp0 = 0.1;
decr  = 1.e-2;
prec  = 1e-6;
// Field of view of parameters changes
// ifov for interferometric ones, sfov for spectroscopic ones.
ifov            = 100*mas2rad;
sfov            = 10.0;
// Plot type for the image
plotLog = 0;
plotPow = 0.5;
npix    = 256;
nlen = 2;
minLen = 1.295e-6;
maxLen = 2.5e-6;
wlenRange = [];//[minLen,maxLen];
crl=1;
crr=0;
//cmax   = 0.075;
cmax   = 210000000;

limVis    =[5e-4,1];
limClos   =[-pi-0.1,pi+0.1];
limVisRes =[-13,13];
limClosRes=[-13,13];
limFreq   =[0, 500];

// Define data directory: in fitOmatic is given the data from the delta cen
//article
dataDir = HOME+"/CVS/fitOmatic/sampleData/DELTA_CEN/";

/*******************************************************/

// Define data files
dataFiles = dataDir+["PRODUCT_DELTA-CEN_1.55-1.86micron_2008-01-08T09:11:09.5209.fits.gz",
         "PRODUCT_DELTA-CEN_1.94-2.27micron_2008-01-06T08:59:16.8295.fits.gz",
         "PRODUCT_DELTA-CEN_1.96-2.29micron_2008-01-08T09:11:09.5209.fits.gz"];
crl=4;
crr=-1;



typei = ["no","g","no"];

parNbWlen  = [[1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
              [1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
              [1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]];

// Set here if you want to vary the parameter or not. The array MUST have the
// same dimensions as parNbWlen
isVariable = [[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
              [1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
              [1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]];



// Random initial parameters. Must be commented out if you have already something
//savedVal    =  random(sum(parNbWlen))*10*mas2rad;
//savedVal    =  1;
// Put here a first guess if you have one. Otherwise this line MUST be
//commented out

sep = 68.7*mas2rad;
pa  = 117.5*deg2rad;
fx  = 0.07;
fx2 = 0.52;
sz  = 1.6*mas2rad;
fx0 = 1-fx-fx2;
savedVal = [1.0, fx2, sz, fx, sep*sin(pa), sep*cos(pa)];
  
//savedVal    =   [1,2.02119,8.63101e-09,1.56141,-48*mas2rad,3.67415e-09];

    /*******************************************************/

include,"run_fit.i";


// yocoGuiWinKill;
//getParamsErrors,tot;
