/***************************************************************************
 *                                                                         *
 *                              fitOmatic                                  *
 *                   Model-fitting prototyping utility                     *
 *                                                                         *
 *                      Copyright 2007, F. Millour                         *
 *                            fmillour@oca.eu                              *
 *                                                                         *
 ***************************************************************************
 *
 * This script contains test functions for analytical models
 *
 * Please note that this script is distributed under the GPL licence,
 * available at http://www.gnu.org/licenses/gpl.txt
 *
 * Please ACKNOWLEDGE the use of this script for any use in a publication
 *
 ***************************************************************************
 * 
 * "@(#) $Id: testPhotocentreModels.i 522 2014-03-20 16:48:28Z fmillour $"
 *
 * History
 * -------
 * $Log: not supported by cvs2svn $
 * Revision 1.3  2010/08/09 13:49:31  fmillour
 * put back revision
 *
 * Revision 1.1  2010/06/14 07:21:38  fmillour
 * Add yorick directory
 *
 * Revision 1.2  2010/06/11 16:20:36  fmillour
 * Update of all headers of directly fitOmatic-related scripts, in order to
 * have them harmonized. This is first step before a better software
 * organization, with idea to distribute it at some point
 *
 * revision 1.1 2009-02-24 16:20:41 +0100;  author: fmillour
 *** empty log message ***
 *
 ***************************************************************************/



include,"photocentreModels.i"; 

wkll;
phase=span(0,3*pi/2.,100);
intens = 1.0;
color=get_color(intens,phase);
pli,array(char(color),1);  

csdvsd() 

  

dataFile = "ALPHA_ARAE_IMAGE/ALPHAARAHR----2.16560e-06----2.17000e-06--------1--------2--------3.fits.gz";
amdlibLoadOiData,awlen, bandWidth, time, fringeSNR, sqVis, sqVisErr, uvCoord, bandFlag, pistonOPDArray, sigmaPistonArray, diffVisAmp, diffVisAmpErr, diffVisPhase, diffVisPhaseErr, vis3Amp, vis3AmpErr, vis3Phase, vis3PhaseErr, cpxVis, cpxVisErr, visCovRI, uv1Coord, uv2Coord, fluxSumPiPj, fluxRatPiPj, PiMultPj, spectrum, spectrumErr, inputOiFile=dataFile;
  
/***************************************************************************/

// parametres model

R           = 2.8 * mas2rad;
oblatness   = 1.2;
assomb      = 0.0;
rapFluxCont = 1.0;
totFlux     = 1.0;
vRot        = 400.0 * kilo2unit;
vExp        = -50.0 * kilo2unit;
theta       = (90+20.0) * deg2rad;
i           = 20.0 * deg2rad;
wlen        = 2.165 * micro2unit;
profilRaie  = 2. * kilo2unit;

u = 10;
v = 4;
       
/***************************************************************************/

off = 0;//-0.00037e-6;
//awlen = awlen+off;

require,"visModels.i";
C2 = visUniformDisk(uvCoord.u(,1), uvCoord.v(,1), awlen, R, 0, 0);

C = visModelExpRotStar(uvCoord.u(,1), uvCoord.v(,1), awlen, R, oblatness, theta, i, assomb, rapFluxCont, totFlux, vRot, vExp, 2.168e-6, profilRaie); 

nChans      = numberof(awlen);

amp = abs(C);
phi = atan(C.im,C.re);

imgCube = imaModelExpRotDisk(R, oblatness, theta, i, assomb, rapFluxCont, totFlux, vRot, vExp, 2.165e-6, profilRaie, awlen, x, y);

spec = [];
for(iChan=1;iChan<=nChans;iChan++)
{
    imgMonochrom = imgCube(,,iChan);
    grow, spec, imgMonochrom(sum,sum)/(sum(diskFlux));
}

wkll;
window,1,style="amdlib3horiz.gs";
for(k=1;k<=3;k++)
{
    plsys,k;
    plg,sqVis(k,,1),awlen;
    plg,amp(k,)^2,awlen,color="red";
    plg,abs(C2(k,))^2,awlen,color="blue";
}

B = abs(uvCoord.u, uvCoord.v);
window,20,style="amdlibLargeBox.gs";
for(k=1;k<=3;k++)
{
    plg,sqVis(k,,1),B(k,)/awlen;
    plg,amp(k,)^2,B(k,)/awlen,color="red";
    plg,abs(C2(k,))^2,B(k,)/awlen,color="blue";
}

window,2,style="amdlib3horiz.gs";
for(k=1;k<=3;k++)
{
    plsys,k;
    plg,diffVisPhase(k,,1),awlen;
    plg,phi(k,)-phi(k,)(avg),awlen,color="red";
}

// window,3,style="amdlibLargeBox.gs";
// plg,spectrum(avg,),awlen;
// plg,spec,awlen,color="red";  

expRotDiskToolbox,diskFlux,diskZone,vitRad,
    x,y,
    x0,y0,R,oblatness,
    vRot,vExp,i,theta,
    totFlux,assomb;
colors = dopplerit(vitRad,wlen) * double(diskZone);  


window,10,width=450,height=450;
pltitle,"champ de vitesse.";
palette,"rainbow.gp";
plf,vitRad,transpose(array(y,numberof(x))),array(x,numberof(y));
yocoPlotColorLookupTable,min(vitRad),max(vitRad),orient=1;
hcps,"~/rotDiskSim_V_Field.ps"; 

vis = phi = spec = photoCntr = [];

for(iChan=1;iChan<=nChans;iChan++)
{ 

    imgMonochrom = imgCube(,,iChan);
    
    if(iChan==1)
        imgColor = get_color(imgMonochrom,(nChans-iChan)/double(nChans)*2*pi);
    else
        imgColor = imgColor +
            get_color(imgMonochrom,(nChans-iChan)/double(nChans)*2*pi);
    
    window,12;
    fma;
    pltitle,"Colour image";
    pli,char(255*imgColor/max(imgColor));
    
    window,13;
    fma;
    pltitle,"image";
    pli,imgMonochrom;
  
    grow,photoCntr,array(computePhotocentre(imgMonochrom),1) * x(dif)(avg)
    
        fourImgMon = fft(imgMonochrom,[1,1]);
  
    grow, spec, imgMonochrom(sum,sum)/(sum(diskFlux));
   
    //    grow, vis, abs(fourImgMon(u,v) / (imgMonochrom(sum,sum)));
    //    grow, phi, atan(fourImgMon(u,v).im,fourImgMon(u,v).re);
  

    pause,1;
}  

  
window,14;
pltitle,"spectre"
    // histogramme,vitRad,xRange,histo,nbBars=nChans,color=,range=;
    plg,spec/spec(1),wlens;
hcps,"~/rotDiskSim_Spec.ps"; 

MIN = min(photoCntr)*rad2mas-avg(photoCntr)*rad2mas;
MAX = max(photoCntr)*rad2mas-avg(photoCntr)*rad2mas;
window,15;
pltitle,"Photocenter X";
plg,photoCntr(1,)*rad2mas-photoCntr(1,)(avg)*rad2mas,awlen;
limits,,,MIN,MAX;
hcps,"~/rotDiskSim_Photocenter.ps";

window,16;
pltitle,"Photocenter Y";
plg,photoCntr(2,)*rad2mas-photoCntr(2,)(avg)*rad2mas,awlen;
limits,,,MIN,MAX;
hcps,"~/rotDiskSim_Photocenter.ps";

  
// window,17;
// pltitle,"visibilit";
// plg,vis,wlens;
// hcps,"~/rotDiskSim_Vis.ps";
  
// window,18;
// pltitle,"phase";
// plg,phi,wlens;
// hcps,"~/rotDiskSim_Phi.ps";  

